/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.cfg.manager.json;

import java.util.Collections;
import java.util.Map;
import org.qiunet.cfg.base.INeedInitCfg;
import org.qiunet.cfg.base.ISimpleMapCfg;
import org.qiunet.cfg.base.ISortable;
import org.qiunet.cfg.manager.base.ISimpleMapCfgManager;
import org.qiunet.cfg.manager.json.BaseJsonCfgManager;
import org.qiunet.utils.collection.safe.SafeMap;

public class SimpleMapJsonCfgManager<ID, Cfg extends ISimpleMapCfg<ID>>
extends BaseJsonCfgManager<ID, Cfg>
implements ISimpleMapCfgManager<ID, Cfg> {
    private Map<ID, Cfg> cfgMap;

    public SimpleMapJsonCfgManager(Class<Cfg> cfgClass) {
        super(cfgClass);
    }

    @Override
    void init() throws Exception {
        this.cfgMap = this.getSimpleMapCfg();
        this.initCfgSelf();
    }

    private void initCfgSelf() {
        if (!INeedInitCfg.class.isAssignableFrom(this.getCfgClass())) {
            return;
        }
        this.cfgMap.values().stream().map(cfg -> (INeedInitCfg)((Object)cfg)).forEach(INeedInitCfg::init);
    }

    protected Map<ID, Cfg> getSimpleMapCfg() throws Exception {
        SafeMap cfgMap = new SafeMap();
        if (ISortable.class.isAssignableFrom(this.getCfgClass())) {
            Collections.sort(this.cfgList);
        }
        for (ISimpleMapCfg cfg : this.cfgList) {
            cfgMap.put(cfg.getId(), (Object)cfg);
        }
        cfgMap.loggerIfAbsent();
        cfgMap.convertToUnmodifiable();
        return cfgMap;
    }

    @Override
    public Map<ID, Cfg> allCfgs() {
        return this.cfgMap;
    }
}

