/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.cfg.manager.keyval;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qiunet.cfg.annotation.CfgValAutoWired;
import org.qiunet.cfg.base.IKeyValCfg;
import org.qiunet.cfg.event.CfgLoadCompleteEvent;
import org.qiunet.cfg.manager.base.ISimpleMapCfgManager;
import org.qiunet.utils.args.ArgsContainer;
import org.qiunet.utils.convert.ConvertManager;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.listener.event.EventListener;
import org.qiunet.utils.reflect.ReflectUtil;
import org.qiunet.utils.scanner.IApplicationContext;
import org.qiunet.utils.scanner.IApplicationContextAware;
import org.qiunet.utils.scanner.ScannerType;
import org.qiunet.utils.string.StringUtil;

public enum KeyValManager {
    instance;


    public long getOrDefault(String key, long defaultVal) {
        KeyValManager0.CfgAutoFieldInfo fieldInfo = KeyValManager0.instance.keyFields.get(key);
        if (fieldInfo == null) {
            return defaultVal;
        }
        return Long.parseLong(fieldInfo.getVal());
    }

    private static enum KeyValManager0 implements IApplicationContextAware
    {
        instance;

        final Map<String, CfgAutoFieldInfo> keyFields = new HashMap<String, CfgAutoFieldInfo>();
        private IApplicationContext context;

        @EventListener
        public void cfgManagerLoadEvent(CfgLoadCompleteEvent eventData) {
            if (this.keyFields.isEmpty()) {
                return;
            }
            eventData.getList().stream().filter(cfg -> IKeyValCfg.class.isAssignableFrom(cfg.getCfgClass())).forEach(cfgManager -> ((ISimpleMapCfgManager)cfgManager).allCfgs().forEach((key, data) -> {
                CfgAutoFieldInfo fieldInfo = this.keyFields.get(key);
                if (fieldInfo == null) {
                    return;
                }
                if (fieldInfo.cfgManager != null && fieldInfo.cfgManager != cfgManager) {
                    throw new CustomException("Key {} is repeated", new Object[]{fieldInfo.getKey()});
                }
                if (fieldInfo.cfgManager == null) {
                    fieldInfo.cfgManager = (ISimpleMapCfgManager)cfgManager;
                }
                fieldInfo.injectVal();
            }));
        }

        public int order() {
            return Integer.MAX_VALUE;
        }

        public ScannerType scannerType() {
            return ScannerType.KEY_VAL_CFG;
        }

        public void setApplicationContext(IApplicationContext context, ArgsContainer argsContainer) throws Exception {
            this.context = context;
            Set fieldSet = context.getFieldsAnnotatedWith(CfgValAutoWired.class);
            for (Field field : fieldSet) {
                String keyName = field.getName();
                CfgValAutoWired annotation = field.getAnnotation(CfgValAutoWired.class);
                if (!StringUtil.isEmpty((String)annotation.key())) {
                    keyName = annotation.key();
                }
                this.keyFields.computeIfAbsent(keyName, x$0 -> new CfgAutoFieldInfo((String)x$0)).addField(field);
            }
        }

        private class CfgAutoFieldInfo {
            ISimpleMapCfgManager<String, ? extends IKeyValCfg> cfgManager;
            private final List<Field> fields = new LinkedList<Field>();
            private final String keyName;

            public CfgAutoFieldInfo(String keyName) {
                this.keyName = keyName;
            }

            void addField(Field field) {
                this.fields.add(field);
            }

            public String getKey() {
                return this.keyName;
            }

            public String getVal() {
                return ((IKeyValCfg)this.cfgManager.getCfgById(this.getKey())).val();
            }

            public void injectVal() {
                this.fields.forEach(field -> {
                    Object realVal = ConvertManager.getInstance().convert(field, this.getVal());
                    Object instance = null;
                    if (!Modifier.isStatic(field.getModifiers())) {
                        instance = KeyValManager0.this.context.getInstanceOfClass(field.getDeclaringClass(), new Object[0]);
                    }
                    ReflectUtil.setField(instance, (Field)field, (Object)realVal);
                });
            }
        }
    }
}

