/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.cfg.wrapper;

import org.qiunet.cfg.base.INestListCfg;
import org.qiunet.cfg.base.INestMapCfg;
import org.qiunet.cfg.base.ISimpleMapCfg;
import org.qiunet.cfg.manager.json.NestListJsonCfgManager;
import org.qiunet.cfg.manager.json.NestMapJsonCfgManager;
import org.qiunet.cfg.manager.json.SimpleMapJsonCfgManager;
import org.qiunet.cfg.wrapper.INestListCfgWrapper;
import org.qiunet.cfg.wrapper.INestMapCfgWrapper;
import org.qiunet.cfg.wrapper.ISimpleMapCfgWrapper;
import org.qiunet.cfg.wrapper.NestListCfgWrapper;
import org.qiunet.cfg.wrapper.NestMapCfgWrapper;
import org.qiunet.cfg.wrapper.SimpleMapCfgWrapper;
import org.qiunet.utils.exceptions.EnumParseException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CfgFileType {
    JSON{

        @Override
        public <ID, Cfg extends ISimpleMapCfg<ID>> ISimpleMapCfgWrapper<ID, Cfg> createSimpleMapCfgWrapper(Class<Cfg> clazz) {
            SimpleMapJsonCfgManager cfgManager = new SimpleMapJsonCfgManager(clazz);
            return new SimpleMapCfgWrapper(cfgManager);
        }

        @Override
        public <ID, SubId, Cfg extends INestMapCfg<ID, SubId>> INestMapCfgWrapper<ID, SubId, Cfg> createNestMapCfgWrapper(Class<Cfg> clazz) {
            NestMapJsonCfgManager cfgManager = new NestMapJsonCfgManager(clazz);
            return new NestMapCfgWrapper(cfgManager);
        }

        @Override
        public <ID, Cfg extends INestListCfg<ID>> INestListCfgWrapper<ID, Cfg> createNestListCfgWrapper(Class<Cfg> clazz) {
            NestListJsonCfgManager cfgManager = new NestListJsonCfgManager(clazz);
            return new NestListCfgWrapper(cfgManager);
        }
    };


    abstract <ID, Cfg extends ISimpleMapCfg<ID>> ISimpleMapCfgWrapper<ID, Cfg> createSimpleMapCfgWrapper(Class<Cfg> var1);

    abstract <ID, SubId, Cfg extends INestMapCfg<ID, SubId>> INestMapCfgWrapper<ID, SubId, Cfg> createNestMapCfgWrapper(Class<Cfg> var1);

    abstract <ID, Cfg extends INestListCfg<ID>> INestListCfgWrapper<ID, Cfg> createNestListCfgWrapper(Class<Cfg> var1);

    static CfgFileType parse(String fileName) {
        int indexOf = fileName.lastIndexOf(".");
        if (indexOf > 0) {
            String postfix = fileName.substring(indexOf + 1);
            for (CfgFileType type : CfgFileType.values()) {
                if (!type.name().equalsIgnoreCase(postfix)) continue;
                return type;
            }
        }
        throw new EnumParseException(fileName);
    }
}

