/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.cfg.wrapper;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.qiunet.cfg.annotation.Cfg;
import org.qiunet.cfg.base.ICfg;
import org.qiunet.cfg.base.INestListCfg;
import org.qiunet.cfg.base.INestMapCfg;
import org.qiunet.cfg.base.ISimpleMapCfg;
import org.qiunet.cfg.wrapper.CfgFileType;
import org.qiunet.cfg.wrapper.ICfgWrapper;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.exceptions.EnumParseException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CfgType {
    SIMPLE_MAP(ISimpleMapCfg.class){

        @Override
        ICfgWrapper getCfgWrapper(CfgFileType cfgFileType, Class<? extends ICfg> clazz) {
            return cfgFileType.createSimpleMapCfgWrapper(clazz);
        }
    }
    ,
    NEST_LIST(INestListCfg.class){

        @Override
        ICfgWrapper getCfgWrapper(CfgFileType cfgFileType, Class<? extends ICfg> clazz) {
            return cfgFileType.createNestListCfgWrapper(clazz);
        }
    }
    ,
    NEST_MAP(INestMapCfg.class){

        @Override
        ICfgWrapper getCfgWrapper(CfgFileType cfgFileType, Class<? extends ICfg> clazz) {
            return cfgFileType.createNestMapCfgWrapper(clazz);
        }
    };

    private final Class<? extends ICfg> clazz;
    static final Map<Class, ICfgWrapper> cfgWrappers;

    private CfgType(Class<? extends ICfg> clazz) {
        this.clazz = clazz;
    }

    abstract ICfgWrapper getCfgWrapper(CfgFileType var1, Class<? extends ICfg> var2);

    public static void createCfgWrapper(Class<? extends ICfg> clazz) {
        Cfg cfg = clazz.getAnnotation(Cfg.class);
        CfgFileType fileType = CfgFileType.parse(cfg.value());
        List is = ClassUtils.getAllInterfaces(clazz);
        for (CfgType type : CfgType.values()) {
            for (Class i : is) {
                if (i != type.clazz) continue;
                cfgWrappers.put(clazz, type.getCfgWrapper(fileType, clazz));
                return;
            }
        }
        throw new EnumParseException(clazz.getName());
    }

    public static <T extends ICfgWrapper> T getCfgWrapper(Class clazz) {
        if (!cfgWrappers.containsKey(clazz)) {
            throw new CustomException("No wrapper for class [{}]", new Object[]{clazz.getName()});
        }
        return (T)cfgWrappers.get(clazz);
    }

    static {
        cfgWrappers = Maps.newHashMap();
    }
}

