/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.cfg.wrapper;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.qiunet.cfg.base.INestListCfg;
import org.qiunet.cfg.wrapper.ICfgWrapper;
import org.qiunet.utils.logger.LoggerType;

public interface INestListCfgWrapper<ID, Cfg extends INestListCfg<ID>>
extends ICfgWrapper<ID, Cfg> {
    public Map<ID, List<Cfg>> allCfgs();

    default public List<Cfg> getCfgsById(ID id) {
        if (!this.contains(id)) {
            LoggerType.DUODUO_CFG_READER.info("Cfg [{}] ID [{}] is missing!", new Object[]{this.getCfgClass().getName(), id});
            return Collections.emptyList();
        }
        return this.allCfgs().get(id);
    }

    default public Cfg getCfgsById(ID id, int index) {
        if (!this.contains(id, index)) {
            LoggerType.DUODUO_CFG_READER.info("Cfg [{}] ID [{}] index [{}] is missing!", new Object[]{this.getCfgClass().getName(), id, index});
            return null;
        }
        return (Cfg)((INestListCfg)this.allCfgs().get(id).get(index));
    }

    default public boolean contains(ID id) {
        return this.allCfgs().containsKey(id);
    }

    default public boolean contains(ID id, int index) {
        if (!this.allCfgs().containsKey(id)) {
            return false;
        }
        List<Cfg> cfgsById = this.getCfgsById(id);
        return index >= 0 && index < cfgsById.size();
    }

    @Override
    default public int size() {
        return this.list().size();
    }
}

