/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.cfg.wrapper;

import java.util.Map;
import org.qiunet.cfg.base.INestMapCfg;
import org.qiunet.cfg.wrapper.ICfgWrapper;
import org.qiunet.utils.logger.LoggerType;

public interface INestMapCfgWrapper<ID, SubID, Cfg extends INestMapCfg<ID, SubID>>
extends ICfgWrapper<ID, Cfg> {
    public Map<ID, Map<SubID, Cfg>> allCfgs();

    default public Cfg getCfgById(ID id, SubID subID) {
        if (!this.contains(id, subID)) {
            LoggerType.DUODUO_CFG_READER.info("Cfg [{}] ID [{}] subId [{}] is missing!", new Object[]{this.getCfgClass().getName(), id, subID});
            return null;
        }
        Map<SubID, Cfg> subIDCfgMap = this.allCfgs().get(id);
        return (Cfg)((INestMapCfg)subIDCfgMap.get(subID));
    }

    default public Map<SubID, Cfg> getCfgsById(ID id) {
        if (!this.contains(id)) {
            LoggerType.DUODUO_CFG_READER.info("Cfg [{}] ID [{}] is missing!", new Object[]{this.getCfgClass().getName(), id});
            return null;
        }
        return this.allCfgs().get(id);
    }

    default public boolean contains(ID id) {
        return this.allCfgs().containsKey(id);
    }

    default public boolean contains(ID id, SubID subID) {
        Map<ID, Map<SubID, Cfg>> allCfgs = this.allCfgs();
        if (!allCfgs.containsKey(id)) {
            return false;
        }
        return allCfgs.get(id).containsKey(subID);
    }

    @Override
    default public int size() {
        return this.list().size();
    }
}

