/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.args;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.qiunet.utils.json.JsonUtil;
import org.qiunet.utils.logger.LoggerType;
import org.qiunet.utils.string.StringUtil;
import org.slf4j.Logger;

public class ArgsMapping {
    private static final Logger logger = LoggerType.DUODUO.getLogger();
    private final List<ArgsDesc> argsDescs = Lists.newLinkedList();
    private final Map<String, String> argsInfos = Maps.newHashMap();

    public ArgsMapping(String[] args) {
        if (args != null && args.length > 0) {
            for (String s : args) {
                if (s == null || !s.startsWith("-") && !s.startsWith("--") || !s.contains("=")) continue;
                try {
                    String[] tt = StringUtil.split(s, "=");
                    if (s.startsWith("--")) {
                        this.argsInfos.put(tt[0].substring(2).trim(), tt[1].trim());
                        continue;
                    }
                    this.argsInfos.put(tt[0].substring(1).trim(), tt[1].trim());
                }
                catch (Exception e) {
                    logger.warn("\uff3b" + s + "\uff3d\u53c2\u6570\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Jvm \u542f\u52a8\u53c2\u6570: " + JsonUtil.toJsonString(this.argsInfos));
        }
    }

    public ArgsMapping addArgsDesc(String shortArgsName, String fullArgsName, String desc) {
        Preconditions.checkState((!StringUtil.isEmpty(shortArgsName) && !StringUtil.isEmpty(fullArgsName) ? 1 : 0) != 0);
        Preconditions.checkState((this.getArgsDesc(shortArgsName) == null && this.getArgsDesc(fullArgsName) == null ? 1 : 0) != 0);
        this.argsDescs.add(new ArgsDesc(shortArgsName, fullArgsName, desc));
        return this;
    }

    public int getIntValue(String argsName) {
        return this.getIntValue(argsName, 0);
    }

    public int getIntValue(String argsName, int defaultVal) {
        String value = this.getValue(argsName);
        if (value == null) {
            return defaultVal;
        }
        return Integer.parseInt(value);
    }

    public String getValue(String argsName, String defaultVal) {
        String value = this.getValue(argsName);
        if (value == null) {
            return defaultVal;
        }
        return value;
    }

    public String getValue(String argsName) {
        if (argsName.startsWith("--")) {
            argsName = argsName.substring(2);
        } else if (argsName.startsWith("-")) {
            argsName = argsName.substring(1);
        }
        if ("h".equals(argsName) || "help".equals(argsName)) {
            this.usage();
            return null;
        }
        ArgsDesc commandDesc = this.getArgsDesc(argsName);
        if (commandDesc == null) {
            return this.argsInfos.get(argsName);
        }
        String result = this.argsInfos.get(commandDesc.shortArgsName);
        if (result != null) {
            return result;
        }
        return this.argsInfos.get(commandDesc.fullArgsName);
    }

    private void usage() {
        System.out.println("USAGE:");
        if (this.argsDescs.isEmpty()) {
            System.out.println("\t\t\u6ca1\u6709\u5b9a\u4e49\u8bf4\u660e!");
        }
        for (ArgsDesc desc : this.argsDescs) {
            System.out.printf("\t\t-%s --%s\t\t%s\n", desc.shortArgsName, desc.fullArgsName, desc.desc);
        }
    }

    public ArgsDesc getArgsDesc(String argsName) {
        for (ArgsDesc desc : this.argsDescs) {
            if (!desc.fullArgsName.equals(argsName) && !desc.shortArgsName.equals(argsName)) continue;
            return desc;
        }
        return null;
    }

    private static class ArgsDesc {
        private final String shortArgsName;
        private final String fullArgsName;
        private final String desc;

        public ArgsDesc(String shortArgsName, String fullArgsName, String desc) {
            this.shortArgsName = shortArgsName;
            this.fullArgsName = fullArgsName;
            this.desc = desc;
        }
    }
}

