/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.args;

import java.util.concurrent.atomic.AtomicReference;
import org.qiunet.utils.args.ArgsDataMap;
import org.qiunet.utils.args.ArgumentKey;

public class Argument<T> {
    private ArgsDataMap allArgsRef;
    private final AtomicReference<T> refData;
    private final ArgumentKey<T> key;

    Argument(ArgumentKey<T> key) {
        this.key = key;
        this.refData = new AtomicReference();
    }

    public T set(T newVal) {
        return this.refData.getAndSet(newVal);
    }

    public boolean compareAndSet(T expect, T newVal) {
        return this.refData.compareAndSet(expect, newVal);
    }

    public void clear() {
        this.refData.set(null);
    }

    public void remove() {
        this.allArgsRef.remove(this.key);
    }

    public T get() {
        if (this.refData.get() == null && this.key.defaultValGetter != null) {
            return this.key.defaultValGetter.get();
        }
        return this.refData.get();
    }

    public T get(T defaultVal) {
        if (this.isNull()) {
            return defaultVal;
        }
        return this.get();
    }

    public boolean isNull() {
        return this.refData.get() == null;
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    public String getName() {
        return this.key.toString();
    }

    public String toString() {
        return "Argument {refData=" + this.refData.get() + ", name='" + this.key + "'}";
    }

    void setAllArgsRef(ArgsDataMap allArgsRef) {
        this.allArgsRef = allArgsRef;
    }
}

