/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.args;

import java.util.function.Supplier;
import org.qiunet.utils.args.Argument;
import org.qiunet.utils.args.ArgumentKey;

public interface IArgsContainer {
    default public <T> Argument<T> getArgument(ArgumentKey<T> key) {
        return this.getArgument(key, true);
    }

    public <T> Argument<T> getArgument(ArgumentKey<T> var1, boolean var2);

    default public void removeArg(ArgumentKey key) {
        Argument argument = this.getArgument(key, false);
        if (argument != null) {
            argument.remove();
        }
    }

    default public void clear(ArgumentKey key) {
        Argument argument = this.getArgument(key, false);
        if (argument != null) {
            argument.clear();
        }
    }

    default public <T> T getVal(ArgumentKey<T> key) {
        return this.getArgument(key).get();
    }

    default public <T> T setVal(ArgumentKey<T> key, T newVal) {
        return this.getArgument(key).set(newVal);
    }

    default public <T> T getVal(ArgumentKey<T> key, T defaultVal) {
        return this.getArgument(key).get(defaultVal);
    }

    default public <T> boolean compareAndSet(ArgumentKey<T> key, T expect, T newVal) {
        return this.getArgument(key).compareAndSet(expect, newVal);
    }

    default public <T> T computeIfAbsent(ArgumentKey<T> key, Supplier<T> newVal) {
        if (this.isNull(key)) {
            this.compareAndSet(key, null, newVal.get());
        }
        return this.getVal(key);
    }

    default public boolean isNull(ArgumentKey key) {
        Argument argument = this.getArgument(key, false);
        return argument == null || argument.isNull();
    }

    default public boolean isNotNull(ArgumentKey key) {
        return !this.isNull(key);
    }
}

