/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.async;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class LazyLoader<T> {
    private final AtomicReference<T> objRef = new AtomicReference();
    private List<Listener<T>> listeners;
    private final Supplier<T> supplier;

    public LazyLoader(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        Object ret = this.objRef.get();
        if (ret == null && (ret = this.supplier.get()) != null && this.objRef.compareAndSet(null, ret) && this.listeners != null) {
            LazyLoader lazyLoader = this;
            synchronized (lazyLoader) {
                Object finalRet = ret;
                this.listeners.forEach(l -> l.run(finalRet));
            }
        }
        return ret;
    }

    public synchronized void addCompleteListener(Listener<T> listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayListWithCapacity((int)3);
        }
        this.listeners.add(listener);
    }

    public synchronized void reset(boolean cleanListener) {
        if (cleanListener) {
            this.listeners = null;
        }
        this.objRef.set(null);
    }

    public boolean isNull() {
        return this.objRef.get() == null;
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    @FunctionalInterface
    public static interface Listener<T> {
        public void run(T var1);
    }
}

