/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.async;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ParallelProcess<E> {
    private final Collection<E> collection;

    private ParallelProcess(Collection<E> collection) {
        this.collection = collection;
    }

    public static <E> ParallelProcess<E> newProcess(Collection<E> collection) {
        return new ParallelProcess<E>(collection);
    }

    public ParallelProcess<E> handle(Consumer<E> consumer) {
        return this.handle(null, consumer);
    }

    public ParallelProcess<E> handle(Predicate<E> filter, Consumer<E> consumer) {
        this.collection.parallelStream().filter(e -> filter == null || !filter.test(e)).forEach(consumer);
        return this;
    }
}

