/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.async.future;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.qiunet.utils.async.future.DFuture;
import org.qiunet.utils.async.future.DPromise;

public class DCompletePromise<V>
extends CompletableFuture<V>
implements DFuture<V>,
DPromise<V>,
CompletionStage<V> {
    private short waiters;
    private Future<V> future;

    public DCompletePromise() {
    }

    DCompletePromise(Future<V> future) {
        this.future = future;
    }

    public void setFuture(Future<V> future) {
        this.future = future;
    }

    @Override
    public boolean isCancelled() {
        if (this.future != null) {
            return this.future.isCancelled();
        }
        return super.isCancelled();
    }

    @Override
    public boolean isSuccess() {
        return this.isDone() && !this.isCompletedExceptionally();
    }

    @Override
    public boolean trySuccess(V result) {
        return this.complete(result);
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        boolean triggered = this.completeExceptionally(cause);
        if (triggered) {
            this.checkNotifyWaiters();
        }
        return triggered;
    }

    @Override
    public boolean complete(V value) {
        boolean triggered = super.complete(value);
        if (triggered) {
            this.checkNotifyWaiters();
        }
        return triggered;
    }

    private void incWaiters() {
        if (this.waiters == Short.MAX_VALUE) {
            throw new IllegalStateException("too many waiters: " + this);
        }
        this.waiters = (short)(this.waiters + 1);
    }

    private void decWaiters() {
        this.waiters = (short)(this.waiters - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DPromise<V> await() throws InterruptedException {
        if (this.isDone()) {
            return this;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        DCompletePromise dCompletePromise = this;
        synchronized (dCompletePromise) {
            while (!this.isDone()) {
                this.incWaiters();
                try {
                    this.wait();
                }
                finally {
                    this.decWaiters();
                }
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DPromise<V> awaitUninterruptibly() {
        if (this.isDone()) {
            return this;
        }
        boolean interrupted = false;
        DCompletePromise dCompletePromise = this;
        synchronized (dCompletePromise) {
            while (!this.isDone()) {
                this.incWaiters();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                finally {
                    this.decWaiters();
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await0(unit.toNanos(timeout), true);
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), true);
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            return this.await0(unit.toNanos(timeout), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await0(long timeoutNanos, boolean interruptable) throws InterruptedException {
        if (this.isDone()) {
            return true;
        }
        if (timeoutNanos <= 0L) {
            return this.isDone();
        }
        if (interruptable && Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        long startTime = System.nanoTime();
        long waitTime = timeoutNanos;
        boolean interrupted = false;
        try {
            do {
                DCompletePromise dCompletePromise = this;
                synchronized (dCompletePromise) {
                    block20: {
                        if (!this.isDone()) break block20;
                        boolean bl = true;
                        return bl;
                    }
                    this.incWaiters();
                    try {
                        this.wait(waitTime / 1000000L, (int)(waitTime % 1000000L));
                    }
                    catch (InterruptedException e) {
                        if (interruptable) {
                            throw e;
                        }
                        interrupted = true;
                    }
                    finally {
                        this.decWaiters();
                    }
                }
                if (!this.isDone()) continue;
                boolean bl = true;
                return bl;
            } while ((waitTime = timeoutNanos - (System.nanoTime() - startTime)) > 0L);
            boolean bl = this.isDone();
            return bl;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private synchronized void checkNotifyWaiters() {
        if (this.waiters > 0) {
            this.notifyAll();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean ret;
        if (this.future != null) {
            this.future.cancel(mayInterruptIfRunning);
        }
        if (ret = super.cancel(mayInterruptIfRunning)) {
            this.checkNotifyWaiters();
        }
        return ret;
    }
}

