/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.async.promise;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class JsPromise<T> {
    private CompletableFuture<T> future;

    private JsPromise(CompletableFuture<T> future) {
        this.future = future;
    }

    public JsPromise(Supplier<T> supplier) {
        this(CompletableFuture.supplyAsync(supplier));
    }

    private JsPromise(JsPromise<?> parent, Function fn) {
        this((CompletableFuture<T>)parent.future.thenApply(fn));
    }

    private JsPromise(JsPromise<?> parent, Consumer action) {
        this((CompletableFuture<T>)parent.future.thenAccept(action));
    }

    public <R> JsPromise<R> then(Function<T, R> fn) {
        return new JsPromise<T>(this, fn);
    }

    public JsPromise<Void> accept(Consumer<T> action) {
        return new JsPromise<Void>(this, action);
    }

    public JsPromise<T> exception(Consumer<Throwable> exConsumer) {
        this.future = this.future.whenComplete((res, ex) -> {
            if (ex != null) {
                exConsumer.accept((Throwable)ex);
            }
        });
        return this;
    }

    public JsPromise<T> exceptionally(Function<Throwable, T> exConsumer) {
        this.future = this.future.exceptionally((Function)exConsumer);
        return this;
    }

    public T get() throws ExecutionException, InterruptedException {
        return this.future.get();
    }
}

