/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.classLoader;

import com.google.common.collect.Lists;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.qiunet.utils.file.FileUtil;
import org.qiunet.utils.logger.LoggerType;
import org.qiunet.utils.string.StringUtil;
import org.qiunet.utils.system.OSUtil;
import org.qiunet.utils.system.SystemPropertyUtil;
import org.qiunet.utils.timer.TimerManager;
import org.slf4j.Logger;

public final class ClassHotSwap {
    private static final Logger logger = LoggerType.DUODUO.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hotSwap(Path classesParentPath) {
        File classDirectory = classesParentPath.toFile();
        if (!classDirectory.isDirectory()) {
            logger.error(" classesParentPath must be a directory!");
            return;
        }
        String classPath = System.getProperty("java.class.path");
        String[] paths = StringUtil.split(classPath, SystemPropertyUtil.getPathSeparator());
        String JavaAgentJarPath = null;
        for (String path : paths) {
            String fileName;
            if (!path.endsWith(".jar") || !(fileName = Paths.get(path, new String[0]).toFile().getName()).matches("JavaAgent.*jar")) continue;
            JavaAgentJarPath = path;
            break;
        }
        if (JavaAgentJarPath == null) {
            logger.error(" JavaAgentJarPath is null!");
            return;
        }
        ArrayList fileList = Lists.newArrayList();
        FileUtil.listFile(classesParentPath, fileList, file -> file.getName().endsWith(".class"));
        if (fileList.isEmpty()) {
            logger.error("Class list is empty!");
            return;
        }
        VirtualMachine vm = null;
        try {
            vm = VirtualMachine.attach(String.valueOf(OSUtil.pid()));
            vm.loadAgent(JavaAgentJarPath, classDirectory.getAbsolutePath());
        }
        catch (Exception e) {
            logger.error("VirtualMachine attach ERROR", (Throwable)e);
        }
        finally {
            if (vm != null) {
                try {
                    vm.detach();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            TimerManager.executor.scheduleWithDelay(() -> {
                try {
                    FileUtil.cleanDirectory(classDirectory);
                    logger.error("\u6e05\u7a7a\u70ed\u66f4\u6587\u4ef6\u5939\u6210\u529f!");
                    return true;
                }
                catch (Exception e) {
                    logger.error("\u6e05\u7a7a\u70ed\u66f4\u6587\u4ef6\u5939\u5931\u8d25!", (Throwable)e);
                    return false;
                }
            }, 30L, TimeUnit.SECONDS);
        }
    }
}

