/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.classLoader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class GameAppClassLoader
extends URLClassLoader {
    private final String[] allowLoaderNames;

    public GameAppClassLoader(String[] paths, String[] allowLoaderNames) {
        super(GameAppClassLoader.returnURLs(paths).toArray(new URL[0]));
        this.allowLoaderNames = allowLoaderNames;
    }

    public GameAppClassLoader(String[] paths, String[] allowLoaderNames, ClassLoader parent) {
        super(GameAppClassLoader.returnURLs(paths).toArray(new URL[0]), parent);
        this.allowLoaderNames = allowLoaderNames;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            return clazz;
        }
        if (Stream.of(this.allowLoaderNames).anyMatch(name::startsWith)) {
            byte[] bytes = this.getClassDefineBytes(name);
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        return super.findClass(name);
    }

    protected byte[] getClassDefineBytes(String name) throws ClassNotFoundException {
        String realName = name.replace('.', '/') + ".class";
        for (URL url : this.getURLs()) {
            if (!url.getPath().endsWith(realName)) continue;
            try {
                return Files.readAllBytes(Paths.get(url.toURI()));
            }
            catch (Exception e) {
                throw new ClassNotFoundException("[" + name + "] not found");
            }
        }
        return null;
    }

    private static List<URL> returnURLs(String[] paths) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            try {
                File folder = new File(path);
                File[] files = folder.listFiles();
                if (files == null) {
                    return urls;
                }
                for (File file : files) {
                    if (!file.isDirectory()) {
                        String fileName = file.getName();
                        if (!fileName.endsWith("jar") && !fileName.endsWith("class")) continue;
                        urls.add(file.toURI().toURL());
                        continue;
                    }
                    urls.addAll(GameAppClassLoader.returnURLs(new String[]{file.getPath()}));
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return urls;
    }
}

