/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.collection;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Collectors;

public class CounterMap<Key> {
    private final Map<Key, Integer> counters = Maps.newConcurrentMap();

    public int getCount(Key key) {
        return this.counters.getOrDefault(key, 0);
    }

    public int increase(Key key, int alter) {
        Preconditions.checkArgument((alter > 0 ? 1 : 0) != 0, (Object)("alter [" + alter + "] must grant than zero!"));
        return this.counters.merge(key, alter, Integer::sum);
    }

    public int increase(Key key) {
        return this.increase(key, 1);
    }

    public int decrease(Key key, int alter) {
        Preconditions.checkArgument((alter > 0 ? 1 : 0) != 0, (Object)("alter [" + alter + "] must grant than zero!"));
        Preconditions.checkArgument((this.getCount(key) >= alter ? 1 : 0) != 0, (Object)"alter number is greater than current");
        Integer integer = this.counters.merge(key, -alter, Integer::sum);
        if (integer <= 0) {
            this.counters.remove(key);
        }
        return integer;
    }

    public int decrease(Key key) {
        return this.decrease(key, 1);
    }

    public void remove(Key ... keys) {
        for (Key key : keys) {
            this.counters.remove(key);
        }
    }

    public Map<Key, Integer> toMap() {
        return this.counters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

