/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.collection;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Set;

public class DuMap<Key, Val> {
    private final BiMap<Key, Val> map1;
    private final BiMap<Val, Key> map2;

    public DuMap(int expectedSize) {
        this.map1 = HashBiMap.create((int)expectedSize);
        this.map2 = this.map1.inverse();
    }

    public DuMap() {
        this(16);
    }

    public DuMap<Key, Val> put(Key key, Val val) {
        if (this.containsKey(key)) {
            throw new IllegalArgumentException("Key [" + key.toString() + "] is repeated");
        }
        if (this.containsVal(val)) {
            throw new IllegalArgumentException("Val [" + val.toString() + "] is repeated");
        }
        this.map1.put(key, val);
        return this;
    }

    public boolean containsKey(Key key) {
        return this.map1.containsKey(key);
    }

    public boolean containsVal(Val val) {
        return this.map2.containsKey(val);
    }

    public Key getKey(Val val) {
        return (Key)this.map2.get(val);
    }

    public Val getVal(Key key) {
        return (Val)this.map1.get(key);
    }

    public boolean isEmpty() {
        return this.map1.isEmpty();
    }

    public int size() {
        return this.map1.size();
    }

    public Set<Key> keys() {
        return this.map1.keySet();
    }

    public Set<Val> vals() {
        return this.map2.keySet();
    }
}

