/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.collection.chain;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.qiunet.utils.collection.enums.ForEachResult;

public class FilterChain<E> {
    private List<E> filters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E e) {
        if (this.filters == null) {
            FilterChain filterChain = this;
            synchronized (filterChain) {
                if (this.filters == null) {
                    this.filters = Lists.newCopyOnWriteArrayList();
                }
            }
        }
        this.filters.add(e);
    }

    public boolean remove(E e) {
        if (this.filters == null) {
            return true;
        }
        return this.filters.remove(e);
    }

    public boolean contains(E e) {
        return this.filters.contains(e);
    }

    public void clean() {
        this.filters = null;
    }

    public List<E> all() {
        return this.filters == null ? Collections.emptyList() : this.filters;
    }

    public void forEach(Function<E, ForEachResult> consumer) {
        this.forEach(consumer, null);
    }

    public void forEach(Function<E, ForEachResult> consumer, Predicate<E> predicate) {
        if (this.filters == null) {
            return;
        }
        for (E filter : this.filters) {
            ForEachResult result;
            if (predicate != null && !predicate.test(filter) || (result = consumer.apply(filter)) != ForEachResult.BREAK) continue;
            break;
        }
    }
}

