/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.collection.custom;

import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.qiunet.utils.collection.custom.ICustomValue;
import org.qiunet.utils.json.JsonUtil;
import org.qiunet.utils.json.TypeReferences;
import org.qiunet.utils.string.StringUtil;

public class CustomValueMap<DATA extends Enum<DATA>> {
    private final Class<DATA> aClass;
    private final Map<DATA, Object> dataMap = Maps.newConcurrentMap();

    public CustomValueMap(Class<DATA> aClass) {
        Preconditions.checkNotNull(aClass);
        this.aClass = aClass;
    }

    public String toDbString() {
        if (this.isEmpty()) {
            return "";
        }
        Map<String, String> collect = this.dataMap.entrySet().stream().collect(Collectors.toMap(en -> ((Enum)en.getKey()).name(), en -> en.getValue().toString()));
        return JsonUtil.toJsonString(collect);
    }

    public void parse(String val) {
        if (StringUtil.isEmpty(val)) {
            return;
        }
        Map<String, String> map = JsonUtil.getGeneralObj(val, TypeReferences.STRING_STRING_MAP, new Feature[0]);
        map.forEach((? super K key, ? super V data) -> {
            DATA keyData = Enum.valueOf(this.aClass, key);
            Object valData = ((ICustomValue)keyData).parse((String)data);
            this.dataMap.put(keyData, valData);
        });
    }

    public String toString() {
        return "CustomValueMap{aClass=" + this.aClass + ", data=" + this.toDbString() + "}";
    }

    public int size() {
        return this.dataMap.size();
    }

    public boolean isEmpty() {
        return this.dataMap.isEmpty();
    }

    public boolean containsKey(DATA key) {
        return this.dataMap.containsKey(key);
    }

    public <T> T get(DATA key) {
        return (T)this.dataMap.get(key);
    }

    public <T> T get(DATA key, T defaultVal) {
        return (T)this.dataMap.getOrDefault(key, defaultVal);
    }

    public <T> T computeIfAbsent(DATA key) {
        return (T)this.dataMap.computeIfAbsent(key, key0 -> ((ICustomValue)((Object)key0)).defaultVal());
    }

    public <T> T put(DATA key, Object value) {
        return (T)this.dataMap.put(key, value);
    }

    public <T> T remove(DATA key) {
        return (T)this.dataMap.remove(key);
    }

    public void clear() {
        this.dataMap.clear();
    }

    public Set<DATA> keySet() {
        return this.dataMap.keySet();
    }

    public void forEach(BiConsumer<DATA, Object> consumer) {
        this.dataMap.forEach(consumer);
    }

    public CustomValueMap<DATA> clone() {
        try {
            return (CustomValueMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            CustomValueMap<DATA> data = new CustomValueMap<DATA>(this.aClass);
            data.dataMap.putAll(this.dataMap);
            return data;
        }
    }
}

