/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.collection.lru;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LRUList<E>
implements List<E> {
    private final Lock lock = new ReentrantLock();
    private final LinkedList<E> data;
    private int length = 10;

    public LRUList(int length) {
        this.length = length;
        if (length < 1) {
            throw new IllegalArgumentException("Length can not less than 1");
        }
        this.data = new LinkedList();
    }

    @Override
    public int size() {
        try {
            this.lock.lock();
            int n = this.data.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.lock.lock();
            boolean bl = this.data.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        try {
            this.lock.lock();
            boolean bl = this.data.contains(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        try {
            this.lock.lock();
            Iterator iterator = this.data.iterator();
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        try {
            this.lock.lock();
            Object[] objectArray = this.data.toArray();
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        try {
            this.lock.lock();
            T[] TArray = this.data.toArray(a);
            return TArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        try {
            this.lock.lock();
            boolean ret = this.data.add(e);
            if (this.size() > this.length) {
                this.data.poll();
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        try {
            this.lock.lock();
            boolean bl = this.data.remove(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        try {
            this.lock.lock();
            boolean bl = this.data.containsAll(c);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        try {
            this.lock.lock();
            boolean bl = this.data.addAll(c);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        try {
            this.lock.lock();
            boolean bl = this.data.addAll(index, c);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        try {
            this.lock.lock();
            boolean bl = this.data.removeAll(c);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        try {
            this.lock.lock();
            boolean bl = this.data.retainAll(c);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.lock.lock();
            this.data.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E get(int index) {
        try {
            this.lock.lock();
            E e = this.data.get(index);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        try {
            this.lock.lock();
            E e = this.data.set(index, element);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void add(int index, E element) {
        try {
            this.lock.lock();
            this.data.add(index, element);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E remove(int index) {
        try {
            this.lock.lock();
            E e = this.data.remove(index);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int indexOf(Object o) {
        try {
            this.lock.lock();
            int n = this.data.indexOf(o);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        try {
            this.lock.lock();
            int n = this.data.lastIndexOf(o);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        try {
            this.lock.lock();
            ListIterator listIterator = this.data.listIterator();
            return listIterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        try {
            this.lock.lock();
            ListIterator<E> listIterator = this.data.listIterator(index);
            return listIterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        try {
            this.lock.lock();
            List list = this.data.subList(fromIndex, toIndex);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }
}

