/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.collection.safe;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.qiunet.utils.collection.safe.ISafeCollection;

public class SafeHashSet<E>
implements Set<E>,
ISafeCollection {
    private Set<E> set;

    public SafeHashSet() {
        this.set = new HashSet();
    }

    public SafeHashSet(Collection<? extends E> c) {
        this.set = new HashSet<E>(c);
    }

    public SafeHashSet(int initialCapacity, float loadFactor) {
        this.set = new HashSet(initialCapacity, loadFactor);
    }

    public SafeHashSet(int initialCapacity) {
        this.set = new HashSet(initialCapacity);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.set.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.set.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public void convertToUnmodifiable() {
        this.set = Collections.unmodifiableSet(this.set);
    }
}

