/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.collection.safe;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.qiunet.utils.collection.safe.ISafeCollection;
import org.qiunet.utils.logger.LoggerType;
import org.slf4j.Logger;

public class SafeMap<KEY, VAL>
implements Map<KEY, VAL>,
ISafeCollection {
    private Logger logger = LoggerType.DUODUO.getLogger();
    private Map<KEY, VAL> map;
    private boolean loggerAbsent;

    public SafeMap(int initialCapacity, float loadFactor) {
        this.map = new LinkedHashMap<KEY, VAL>(initialCapacity, loadFactor);
    }

    public SafeMap(int initialCapacity) {
        this.map = new LinkedHashMap<KEY, VAL>(initialCapacity);
    }

    public SafeMap() {
        this.map = new LinkedHashMap<KEY, VAL>();
    }

    public SafeMap(Map<? extends KEY, ? extends VAL> m) {
        this.map = new LinkedHashMap<KEY, VAL>(m);
    }

    public SafeMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        this.map = new LinkedHashMap<KEY, VAL>(initialCapacity, loadFactor, accessOrder);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public VAL get(Object key) {
        VAL val = this.map.get(key);
        if (this.loggerAbsent && val == null) {
            this.logger.error("=================Key [" + key + "] is not in map.=============== ");
        }
        return val;
    }

    @Override
    public VAL put(KEY key, VAL value) {
        return this.map.put(key, value);
    }

    @Override
    public VAL remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends KEY, ? extends VAL> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<KEY> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<VAL> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<KEY, VAL>> entrySet() {
        return this.map.entrySet();
    }

    public void loggerIfAbsent() {
        this.loggerAbsent = true;
    }

    @Override
    public void convertToUnmodifiable() {
        this.map = Collections.unmodifiableMap(this.map);
    }
}

