/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.collection.wheel;

import com.google.common.collect.Lists;
import java.util.List;
import org.qiunet.utils.collection.enums.ForEachResult;
import org.qiunet.utils.common.functional.IndexForeach;

public class WheelList<E> {
    private final List<Node<E>> list = Lists.newArrayList();

    public WheelList(List<E> list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Node<E> node = new Node<E>(i, list.get(i));
            this.list.add(node);
            if (i > 0) {
                this.list.get((int)(i - 1)).next = node;
            }
            if (i != list.size() - 1) continue;
            node.next = this.list.get(0);
        }
    }

    public int nextForeach(int preIndex, IndexForeach<E> consumer) {
        Node<E> eNode = this.list.get(preIndex);
        return this.foreach(eNode.next.pos, consumer);
    }

    public int foreach(int startIndex, IndexForeach<E> consumer) {
        Node<E> eNode = this.list.get(startIndex);
        while (consumer.consume(eNode.pos, eNode.e) != ForEachResult.BREAK) {
            eNode = eNode.next;
            if (eNode.pos != startIndex) continue;
        }
        return eNode.pos;
    }

    private static class Node<E> {
        private final int pos;
        private final E e;
        private Node<E> next;

        public Node(int pos, E e) {
            this.pos = pos;
            this.e = e;
        }
    }
}

