/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CommonUtil {
    private CommonUtil() {
    }

    @SafeVarargs
    public static <T> boolean existInList(T element, T ... arrays) {
        if (arrays == null || element == null) {
            return false;
        }
        return Arrays.asList(arrays).contains(element);
    }

    public static <T> boolean existInList(T element, Collection<T> list) {
        if (list.isEmpty() || element == null) {
            return false;
        }
        return list.stream().anyMatch(ele -> ele.equals(element));
    }

    public static <T> List<T> getSubListPage(List<T> list, int skip, int count) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.stream().skip(skip).limit(count).collect(Collectors.toList());
    }

    public static void reverse(byte[] array) {
        CommonUtil.reverse(array, 1);
    }

    public static void reverse(byte[] array, int step) {
        if (array == null || array.length <= 1) {
            return;
        }
        int len = array.length;
        int loopNum = len / 2;
        for (int i = 0; i < loopNum; i += step) {
            byte temp = array[i];
            int last = len - 1 - i;
            array[i] = array[last];
            array[last] = temp;
        }
    }

    public static void reverse(int[] array) {
        if (array == null || array.length <= 1) {
            return;
        }
        int len = array.length;
        int loopNum = len / 2;
        for (int i = 0; i < loopNum; ++i) {
            int last = len - 1 - i;
            int temp = array[i];
            array[i] = array[last];
            array[last] = temp;
        }
    }

    public static boolean isEmptyMap(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmptyMap(Map<?, ?> map) {
        return !CommonUtil.isEmptyMap(map);
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CommonUtil.isEmpty(collection);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }
}

