/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qiunet.utils.args.ArgsContainer;
import org.qiunet.utils.config.anno.DConfig;
import org.qiunet.utils.config.anno.DConfigInstance;
import org.qiunet.utils.config.anno.DConfigValue;
import org.qiunet.utils.config.conf.DHocon;
import org.qiunet.utils.config.properties.DProperties;
import org.qiunet.utils.convert.ConvertManager;
import org.qiunet.utils.data.IKeyValueData;
import org.qiunet.utils.data.KeyValueData;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.logger.LoggerType;
import org.qiunet.utils.scanner.IApplicationContext;
import org.qiunet.utils.scanner.IApplicationContextAware;
import org.qiunet.utils.scanner.ScannerType;
import org.qiunet.utils.string.StringUtil;

enum ConfigContext implements IApplicationContextAware
{
    instance;

    private final Map<String, ConfigData> datas = Maps.newHashMap();
    private IApplicationContext context;
    @DConfigValue
    private String field_holder;
    private Field field_holder_field;

    private ConfigContext() {
        try {
            this.field_holder_field = ConfigContext.class.getDeclaredField("field_holder");
        }
        catch (NoSuchFieldException e) {
            LoggerType.DUODUO.error("", e);
        }
    }

    @Override
    public int order() {
        return 0x7FFFFFFE;
    }

    @Override
    public ScannerType scannerType() {
        return ScannerType.FILE_CONFIG;
    }

    @Override
    public void setApplicationContext(IApplicationContext context, ArgsContainer argsContainer) throws Exception {
        this.context = context;
        this.loadInstanceFields();
        this.loadField();
        this.datas.values().forEach(this::loadFile);
    }

    private void loadInstanceFields() {
        Set<Field> fields = this.context.getFieldsAnnotatedWith(DConfigInstance.class);
        fields.forEach(field -> {
            DConfigInstance annotation = field.getAnnotation(DConfigInstance.class);
            Preconditions.checkState((!StringUtil.isEmpty(annotation.value()) ? 1 : 0) != 0, (Object)"config name is require!");
            ConfigData configData = this.datas.computeIfAbsent(annotation.value(), x$0 -> new ConfigData((String)x$0));
            configData.instanceFields.add((Field)field);
        });
    }

    private void loadField() {
        Set<Field> fieldSet = this.context.getFieldsAnnotatedWith(DConfigValue.class);
        for (Field field : fieldSet) {
            String configName;
            if (field.equals(this.field_holder_field)) continue;
            DConfig annotation = field.getDeclaringClass().getAnnotation(DConfig.class);
            if (annotation != null) {
                configName = annotation.value();
            } else {
                DConfigValue fieldAnnotation = field.getAnnotation(DConfigValue.class);
                Preconditions.checkState((!StringUtil.isEmpty(fieldAnnotation.configName()) ? 1 : 0) != 0, (Object)"config name is require!");
                configName = fieldAnnotation.configName();
            }
            ConfigData data = this.datas.computeIfAbsent(configName, x$0 -> new ConfigData((String)x$0));
            if (annotation != null && annotation.listenerChange()) {
                data.listenerChanged = true;
            }
            data.fields.add(field);
        }
    }

    private void loadFile(ConfigData data) {
        this.loadFile(data.configName, data.fields, data.loadData(keyVal -> this.loadFile(data.configName, data.fields, keyVal)));
    }

    private void loadFile(String name, List<Field> fieldList, IKeyValueData<String, String> keyValueData) {
        fieldList.forEach(field -> {
            DConfigValue annotation = field.getAnnotation(DConfigValue.class);
            String keyName = annotation.value();
            if (StringUtil.isEmpty(keyName)) {
                keyName = field.getName();
            }
            Preconditions.checkState((keyValueData.containKey(keyName) || !"-".equals(annotation.defaultVal()) ? 1 : 0) != 0, (Object)("Config [" + name + "] do not have key [" + keyName + "], but field annotation defaultVal is empty!"));
            Object val = keyValueData.getString(keyName, annotation.defaultVal());
            if (!StringUtil.isEmpty(annotation.prefixKey())) {
                String prefixVal = keyValueData.getString(annotation.prefixKey());
                if (prefixVal == null) {
                    throw new CustomException("Prefix key {} value is empty", annotation.prefixKey());
                }
                val = prefixVal + (String)val;
            }
            if (!StringUtil.isEmpty(annotation.postfixKey())) {
                String postfixVal = keyValueData.getString(annotation.postfixKey());
                if (postfixVal == null) {
                    throw new CustomException("Postfix key {} value is empty", annotation.postfixKey());
                }
                val = (String)val + postfixVal;
            }
            Object instance = null;
            if (!Modifier.isStatic(field.getModifiers())) {
                instance = this.context.getInstanceOfClass(field.getDeclaringClass(), new Object[0]);
            }
            try {
                field.setAccessible(true);
                field.set(instance, ConvertManager.instance.convert((Field)field, (String)val));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }

    private class ConfigData {
        String configName;
        boolean listenerChanged;
        List<Field> fields = Lists.newLinkedList();
        List<Field> instanceFields = Lists.newArrayListWithCapacity((int)3);

        ConfigData(String configName) {
            this.configName = configName;
        }

        IKeyValueData<String, String> loadData(IKeyValueData.DataChangeListener<String, String> changeListener) {
            KeyValueData data;
            if (!this.listenerChanged) {
                changeListener = null;
            }
            if (this.configName.endsWith(".properties")) {
                data = new DProperties(this.configName, changeListener);
            } else if (this.configName.endsWith(".conf")) {
                data = new DHocon(this.configName, changeListener);
            } else {
                throw new CustomException("Not support config for [{}]", this.configName);
            }
            if (this.instanceFields != null) {
                for (Field instanceField : this.instanceFields) {
                    Object instance = null;
                    if (!Modifier.isStatic(instanceField.getModifiers())) {
                        instance = ConfigContext.this.context.getInstanceOfClass(instanceField.getDeclaringClass(), new Object[0]);
                    }
                    try {
                        instanceField.setAccessible(true);
                        instanceField.set(instance, data);
                    }
                    catch (IllegalAccessException e) {
                        LoggerType.DUODUO.error("Exception", e);
                    }
                }
                this.instanceFields = null;
            }
            return data;
        }
    }
}

