/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.config;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.qiunet.utils.data.IKeyValueData;
import org.qiunet.utils.data.KeyValueData;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.file.FileUtil;
import org.qiunet.utils.file.IFileChangeCallback;
import org.qiunet.utils.logger.LoggerType;
import org.slf4j.Logger;

public class ConfigFileUtil {
    private static final Logger logger = LoggerType.DUODUO.getLogger();

    public static Properties loaderProperties(File propertiesFile) {
        LoggerType.DUODUO.info("Load config file from {}", propertiesFile.getAbsolutePath());
        Preconditions.checkNotNull((Object)propertiesFile);
        Preconditions.checkArgument((boolean)propertiesFile.getName().endsWith("properties"), (Object)"file must be a properties file");
        Properties tempProperties = new Properties();
        try (InputStream fis = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);
             InputStreamReader isr = new InputStreamReader(fis, StandardCharsets.UTF_8);){
            tempProperties.load(isr);
        }
        catch (Exception e) {
            logger.error("[LoaderProperties] Exception: ", (Throwable)e);
        }
        return tempProperties;
    }

    public static Config loadConf(String fileName) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(fileName);
        assert (resource != null);
        LoggerType.DUODUO.info("Load config from {}", resource.getFile());
        Config config = ConfigFactory.load((String)fileName);
        config.resolve();
        return config;
    }

    public static IKeyValueData<Object, Object> loadConfig(String fileName) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
        Preconditions.checkNotNull((Object)url, (String)"fileName %s has not find in classpath", (Object)fileName);
        File file = new File(url.getFile());
        if (fileName.endsWith(".properties")) {
            return new KeyValueData<Object, Object>(ConfigFileUtil.loaderProperties(file));
        }
        if (fileName.endsWith(".conf")) {
            Config config = ConfigFileUtil.loadConf(fileName);
            Map<Object, Object> collect = config.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, en -> ((ConfigValue)en.getValue()).unwrapped().toString()));
            return new KeyValueData<Object, Object>(collect);
        }
        throw new CustomException("Not support!", new Object[0]);
    }

    public static IKeyValueData<Object, Object> loadConfig(String fileName, IFileChangeCallback changeCallback) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
        Preconditions.checkNotNull((Object)url, (String)"fileName %s has not find in classpath", (Object)fileName);
        File file = new File(url.getFile());
        FileUtil.changeListener(file, changeCallback);
        return ConfigFileUtil.loadConfig(fileName);
    }
}

