/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.config.conf;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.stream.Collectors;
import org.qiunet.utils.config.ConfigFileUtil;
import org.qiunet.utils.data.IKeyValueData;
import org.qiunet.utils.data.KeyValueData;
import org.qiunet.utils.file.FileUtil;

public final class DHocon
extends KeyValueData<String, String> {
    private Config config;

    public DHocon(String fileName) {
        this(fileName, null);
    }

    public DHocon(String fileName, IKeyValueData.DataChangeListener<String, String> changeListener) {
        super(changeListener);
        URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
        Preconditions.checkNotNull((Object)url, (String)"fileName %s has not find in classpath", (Object)fileName);
        File file = new File(url.getFile());
        if (changeListener != null) {
            FileUtil.changeListener(file, key -> this.load0(fileName));
        }
        this.load0(fileName);
    }

    private void load0(String fileName) {
        this.config = ConfigFileUtil.loadConf(fileName);
        Map<String, String> collect = this.config.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, en -> ((ConfigValue)en.getValue()).unwrapped().toString()));
        super.load(collect);
    }

    public Config getConfig() {
        return this.config;
    }
}

