/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.config.properties;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.qiunet.utils.config.ConfigFileUtil;
import org.qiunet.utils.data.IKeyValueData;
import org.qiunet.utils.data.KeyValueData;
import org.qiunet.utils.file.FileUtil;

public final class DProperties
extends KeyValueData<String, String> {
    public DProperties(String fileName) {
        this(fileName, null);
    }

    public DProperties(String fileName, IKeyValueData.DataChangeListener<String, String> changeListener) {
        super(changeListener);
        URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
        Preconditions.checkNotNull((Object)url, (String)"fileName %s has not find in classpath", (Object)fileName);
        File file = new File(url.getFile());
        if (changeListener != null) {
            FileUtil.changeListener(file, this::load0);
        }
        this.load0(file);
    }

    private void load0(File file) {
        Properties properties = ConfigFileUtil.loaderProperties(file);
        Map<String, String> collect = properties.entrySet().stream().collect(Collectors.toMap(en -> en.getKey().toString(), en -> en.getValue().toString()));
        super.load(collect);
    }
}

