/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.convert;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.qiunet.utils.convert.BaseObjConvert;
import org.qiunet.utils.exceptions.CustomException;

public abstract class BaseObjListConvert<T>
extends BaseObjConvert<List<T>> {
    private final Class<T> clazz;

    public BaseObjListConvert() {
        Type[] actualTypeArguments = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        this.clazz = (Class)actualTypeArguments[0];
    }

    @Override
    public boolean canConvert(Field field) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Type genericType = field.getGenericType();
        if (!ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
            return false;
        }
        return ((ParameterizedType)genericType).getActualTypeArguments()[0] == this.clazz;
    }

    @Override
    public boolean canConvert(Class<?> type) {
        throw new CustomException("Not support", new Object[0]);
    }
}

