/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.convert;

import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.qiunet.utils.args.ArgsContainer;
import org.qiunet.utils.convert.BaseObjConvert;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.json.JsonUtil;
import org.qiunet.utils.logger.LoggerType;
import org.qiunet.utils.reflect.ReflectUtil;
import org.qiunet.utils.scanner.IApplicationContext;
import org.qiunet.utils.scanner.IApplicationContextAware;
import org.qiunet.utils.scanner.ScannerType;
import org.qiunet.utils.string.StringUtil;

public enum ConvertManager implements IApplicationContextAware
{
    instance;

    private List<? extends BaseObjConvert> converts = Lists.newArrayList();
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private static final Map<Type, BaseObjConvert> convertMapping;

    public static ConvertManager getInstance() {
        return instance;
    }

    @Override
    public ScannerType scannerType() {
        return ScannerType.OBJ_CONVERT;
    }

    public void covertAndSet(Object instance, Field field, String val) {
        ReflectUtil.setField(instance, field, this.convert(field, val));
    }

    public Object convert(Field field, String val) {
        if (!this.inited.get()) {
            throw new CustomException("ConvertManager not init", new Object[0]);
        }
        BaseObjConvert objConvert = convertMapping.computeIfAbsent(field.getGenericType(), clz -> {
            for (BaseObjConvert baseObjConvert : this.converts) {
                if (!baseObjConvert.canConvert(field)) continue;
                return baseObjConvert;
            }
            return null;
        });
        if (objConvert != null) {
            return objConvert.fromString(field, val);
        }
        if (StringUtil.isEmpty(val)) {
            return null;
        }
        if (val.startsWith("{") && val.endsWith("}") || val.startsWith("[") && val.endsWith("]")) {
            return JsonUtil.getGeneralObj(val, field.getGenericType(), new Feature[0]);
        }
        throw new CustomException("Can not convert class type for field[{}] value[{}]", field.getName(), val);
    }

    @Override
    public void setApplicationContext(IApplicationContext context, ArgsContainer argsContainer) {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        this.converts = context.getSubTypesOf(BaseObjConvert.class).stream().filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).map(clazz -> (BaseObjConvert)context.getInstanceOfClass((Class)clazz, new Object[0])).filter(Objects::nonNull).collect(Collectors.toList());
        LoggerType.DUODUO_CFG_READER.debug("find {} cfg field convert!", this.converts.size());
    }

    public List<? extends BaseObjConvert> getConverts() {
        return this.converts;
    }

    @Override
    public int order() {
        return Integer.MAX_VALUE;
    }

    static {
        convertMapping = Maps.newConcurrentMap();
    }
}

