/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.convert;

import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.qiunet.utils.convert.BaseObjConvert;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.string.StringUtil;

public class DateConvert
extends BaseObjConvert<Date> {
    private static final ThreadLocal<SimpleDateFormat> datetimeSdf = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private static final ThreadLocal<SimpleDateFormat> dateSdf = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));
    private static final Date ZERO_DATE = new Date(0L);

    @Override
    public Date fromString(Field field, String str) {
        if (StringUtil.isEmpty(str)) {
            return ZERO_DATE;
        }
        try {
            if (str.length() > 10) {
                return datetimeSdf.get().parse(str);
            }
            return dateSdf.get().parse(str);
        }
        catch (ParseException e) {
            throw new CustomException(e, "string {} to Date error", str);
        }
    }
}

