/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.convert;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.qiunet.utils.async.LazyLoader;
import org.qiunet.utils.convert.BaseObjConvert;
import org.qiunet.utils.convert.IEnumReadable;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.string.StringUtil;

public class EnumConvert
extends BaseObjConvert<Enum> {
    private static final LazyLoader<Class<?>> enumReadableClass = new LazyLoader<Class>(() -> {
        try {
            return Class.forName("com.baidu.bjf.remoting.protobuf.EnumReadable");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    });

    @Override
    public Enum fromString(Field field, String value) {
        if (StringUtil.isEmpty(value)) {
            return null;
        }
        Class<?> enumClass = field.getType();
        if (StringUtil.isNum(value)) {
            Class<?> aClass;
            Integer val = Integer.valueOf(value);
            Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
            boolean enumReadable = IEnumReadable.class.isAssignableFrom(enumClass);
            if (!enumReadable && (aClass = enumReadableClass.get()) != null && aClass.isAssignableFrom(enumClass)) {
                enumReadable = true;
            }
            for (Enum enumConstant : enumConstants) {
                int enumValue;
                int n = enumValue = enumReadable ? this.getEnumValue(enumConstant) : enumConstant.ordinal();
                if (enumValue != val) continue;
                return enumConstant;
            }
            return null;
        }
        return Enum.valueOf(enumClass, value);
    }

    private int getEnumValue(Enum enumConstant) {
        try {
            Method method = enumConstant.getDeclaringClass().getDeclaredMethod("value", new Class[0]);
            return (Integer)method.invoke((Object)enumConstant, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CustomException(e, "convert enum {} error!", enumConstant.getDeclaringClass().getName());
        }
    }

    @Override
    public boolean canConvert(Class<?> type) {
        return type.isEnum() || Enum.class.isAssignableFrom(type);
    }
}

