/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.data;

import java.nio.ByteBuffer;

public class ByteUtil {
    public static int readU16bit(byte[] code, int index) {
        return (code[index] & 0xFF) << 8 | code[index + 1] & 0xFF;
    }

    public static int readS16bit(byte[] code, int index) {
        return code[index] << 8 | code[index + 1] & 0xFF;
    }

    public static int read32bit(byte[] code, int index) {
        return code[index] << 24 | (code[index + 1] & 0xFF) << 16 | (code[index + 2] & 0xFF) << 8 | code[index + 3] & 0xFF;
    }

    public static byte[] short2Bytes(int value) {
        return ByteBuffer.allocate(2).putShort((short)value).array();
    }

    public static byte[] int2Bytes(int value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    public static byte[] long2Bytes(long value) {
        return ByteBuffer.allocate(8).putLong(value).array();
    }

    public static byte[] readBytebuffer(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            return buffer.array();
        }
        return ByteUtil.readBytebuffer(buffer, 0, buffer.limit());
    }

    public static byte[] readBytebuffer(ByteBuffer buffer, int index, int length) {
        byte[] bytes = new byte[length];
        buffer.mark();
        buffer.get(bytes, index, length);
        buffer.reset();
        return bytes;
    }
}

