/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.data;

import java.util.Map;
import org.qiunet.utils.common.CommonUtil;
import org.qiunet.utils.logger.LoggerType;

public interface IKeyValueData<K, V> {
    default public boolean containKey(K key) {
        return this.returnMap().containsKey(key);
    }

    default public void merge(Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException("Map can not be null for KeyValueData");
        }
        this.returnMap().putAll(map);
    }

    public Map<K, V> returnMap();

    default public V getValue(K key) {
        return this.returnMap().get(key);
    }

    default public V _getOrDefault(K key, V defaultVal) {
        return this.returnMap().getOrDefault(key, defaultVal);
    }

    default public String getString(K key) {
        V v = this.getValue(key);
        if (v == null) {
            LoggerType.DUODUO.error("=================Key [" + key + "] is not in map.=============== ");
            return null;
        }
        return v.toString();
    }

    default public String getString(K key, String defaultVal) {
        String rt = defaultVal;
        V v = this.getValue(key);
        if (v != null) {
            rt = v.toString().trim();
        }
        return rt;
    }

    default public int getInt(K key, int defaultVal) {
        if (!this.containKey(key)) {
            return defaultVal;
        }
        return this.getInt(key);
    }

    default public int getInt(K key) {
        return Integer.parseInt(this.getString(key));
    }

    default public float getFloat(K key, float defaultVal) {
        if (!this.containKey(key)) {
            return defaultVal;
        }
        return this.getFloat(key);
    }

    default public float getFloat(K key) {
        return Float.parseFloat(this.getString(key));
    }

    default public long getLong(K key, long defaultVal) {
        if (!this.containKey(key)) {
            return defaultVal;
        }
        return this.getLong(key);
    }

    default public long getLong(K key) {
        return Long.parseLong(this.getString(key));
    }

    default public double getDouble(K key, double defaultVal) {
        if (!this.containKey(key)) {
            return defaultVal;
        }
        return this.getDouble(key);
    }

    default public double getDouble(K key) {
        return Double.parseDouble(this.getString(key));
    }

    default public boolean getBoolean(K key) {
        if (!this.containKey(key)) {
            return false;
        }
        return CommonUtil.existInList(this.getString(key), "1", "yes", "true");
    }

    @FunctionalInterface
    public static interface DataChangeListener<K, V> {
        public void accept(IKeyValueData<K, V> var1);
    }
}

