/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.date;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.qiunet.utils.common.IRunnable;

public final class DateUtil {
    private static final ZoneId defaultZoneId = ZoneId.systemDefault();
    private static final Clock SYSTEM_CLOCK;
    private static Clock CLOCK;
    public static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER;
    public static final long DAY_SECONDS = 86400L;
    public static final long DAY_MS = 86400000L;
    public static final long WEEK_SECONDS = 604800L;
    public static final long WEEK_MS = 604800000L;
    private static final Map<String, DateTimeFormatter> DATE_FORMATS;

    public static long currSeconds() {
        return DateUtil.currentTimeMillis() / 1000L;
    }

    public static Instant currentInstant() {
        return CLOCK.instant();
    }

    public static LocalDateTime nowLocalDateTime() {
        return DateUtil.nowLocalDateTime(DateUtil.getDefaultZoneId());
    }

    public static LocalDateTime nowLocalDateTime(ZoneId zoneId) {
        return LocalDateTime.ofInstant(DateUtil.currentInstant(), zoneId);
    }

    public static ZoneId getDefaultZoneId() {
        return defaultZoneId;
    }

    public static void setTimeOffset(long offsetValue, TimeUnit unit) {
        CLOCK = Clock.offset(SYSTEM_CLOCK, Duration.ofMillis(unit.toMillis(offsetValue)));
    }

    private DateUtil() {
    }

    public static long calConsumeMillisSeconds(IRunnable runnable) throws Exception {
        long start = System.currentTimeMillis();
        runnable.run();
        return System.currentTimeMillis() - start;
    }

    public static String dateToString(long millis) {
        return DateUtil.dateToString(millis, DEFAULT_DATE_TIME_FORMAT);
    }

    public static String dateToString(LocalDateTime date) {
        return DEFAULT_DATE_TIME_FORMATTER.format(date);
    }

    public static long getMilliByTime(LocalDateTime time) {
        return time.atZone(DateUtil.getDefaultZoneId()).toInstant().toEpochMilli();
    }

    public static long getMilliByTime(LocalDateTime time, ZoneOffset offset) {
        return time.toInstant(offset).toEpochMilli();
    }

    public static long getSecondsByTime(LocalDateTime time) {
        return time.atZone(DateUtil.getDefaultZoneId()).toInstant().getEpochSecond();
    }

    public static LocalDateTime getLocalDateTime(long milliseconds) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(milliseconds), DateUtil.getDefaultZoneId());
    }

    public static LocalDateTime getLocalDateTime(long milliseconds, ZoneOffset zoneOffset) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(milliseconds), zoneOffset);
    }

    public static String dateToString(Date date) {
        return DateUtil.dateToString(date, DEFAULT_DATE_TIME_FORMAT);
    }

    public static String dateToString(Date date, String format) {
        return DateUtil.dateToString(date.getTime(), format);
    }

    public static String dateToString(long millis, String format) {
        return DateUtil.dateToString(DateUtil.getLocalDateTime(millis), format);
    }

    public static String dateToString(LocalDateTime date, String format) {
        return DateUtil.returnFormatter(format).format(date);
    }

    public static LocalDateTime stringToDate(String stringValue, String format) {
        return LocalDateTime.parse(stringValue, DateUtil.returnFormatter(format));
    }

    public static LocalDateTime stringToDate(String stringValue) {
        return DateUtil.stringToDate(stringValue, DEFAULT_DATE_TIME_FORMAT);
    }

    public static boolean isBetweenDays(LocalDateTime date, LocalDateTime dateBefore, LocalDateTime dateLast) {
        long d = DateUtil.getMilliByTime(date);
        long d1 = DateUtil.getMilliByTime(dateBefore);
        long d2 = DateUtil.getMilliByTime(dateLast);
        return d >= d1 && d < d2;
    }

    public static long currentTimeMillis() {
        return CLOCK.millis();
    }

    public static boolean isSameDay(LocalDateTime time1, LocalDateTime time2) {
        LocalDate localDate1 = time1.atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = time2.atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate1.isEqual(localDate2);
    }

    public static boolean isSameDay(long time1, long time2) {
        return DateUtil.isSameDay(DateUtil.getLocalDateTime(time1), DateUtil.getLocalDateTime(time2));
    }

    public static boolean isSameWeek(long time1, long time2) {
        LocalDateTime ldt1 = DateUtil.getLocalDateTime(time1);
        LocalDateTime ldt2 = DateUtil.getLocalDateTime(time2);
        TemporalField woy = WeekFields.of(Locale.getDefault()).weekOfWeekBasedYear();
        return ldt1.getYear() == ldt2.getYear() && ldt1.get(woy) == ldt2.get(woy);
    }

    public static boolean isSameMonth(long time1, long time2) {
        LocalDateTime ldt1 = DateUtil.getLocalDateTime(time1);
        LocalDateTime ldt2 = DateUtil.getLocalDateTime(time2);
        return ldt1.getYear() == ldt2.getYear() && ldt1.getMonthValue() == ldt2.getMonthValue();
    }

    public static boolean isSameQuarter(long time1, long time2) {
        LocalDateTime ldt1 = DateUtil.getLocalDateTime(time1);
        LocalDateTime ldt2 = DateUtil.getLocalDateTime(time2);
        return ldt1.getYear() == ldt2.getYear() && ldt1.getMonthValue() / 4 == ldt2.getMonthValue() / 4;
    }

    public static boolean isSameYear(long time1, long time2) {
        return DateUtil.getLocalDateTime(time1).getYear() == DateUtil.getLocalDateTime(time2).getYear();
    }

    public static int getDayOfMonth(long time) {
        return DateUtil.getLocalDateTime(time).getDayOfMonth();
    }

    public static int getDayOfMonth() {
        return DateUtil.getDayOfMonth(DateUtil.currentTimeMillis());
    }

    public static int getDayOfYear(long time) {
        return DateUtil.getLocalDateTime(time).getDayOfYear();
    }

    public static int getDayOfYear() {
        return DateUtil.getDayOfYear(DateUtil.currentTimeMillis());
    }

    public static int getDayOfWeek(long time) {
        return DateUtil.getLocalDateTime(time).getDayOfWeek().getValue();
    }

    public static int getDayOfWeek() {
        return DateUtil.getDayOfWeek(DateUtil.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DateTimeFormatter returnFormatter(String pattern) {
        DateTimeFormatter formatter = DATE_FORMATS.get(pattern);
        if (formatter != null) return formatter;
        Class<DateUtil> clazz = DateUtil.class;
        synchronized (DateUtil.class) {
            return DATE_FORMATS.computeIfAbsent(pattern, DateTimeFormatter::ofPattern);
        }
    }

    public static boolean isLeap(int year) {
        return Year.isLeap(year);
    }

    public static int getLastDayOfMonth(int year, int month) {
        return YearMonth.of(year, month).lengthOfMonth();
    }

    static {
        CLOCK = SYSTEM_CLOCK = Clock.systemDefaultZone();
        DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_FORMAT).withLocale(Locale.getDefault());
        DATE_FORMATS = Maps.newHashMap((Map)ImmutableMap.of((Object)DEFAULT_DATE_TIME_FORMAT, (Object)DEFAULT_DATE_TIME_FORMATTER));
    }
}

