/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.fakeenum;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.qiunet.utils.args.ArgsContainer;
import org.qiunet.utils.async.LazyLoader;
import org.qiunet.utils.common.collector.DCollectors;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.fakeenum.FakeEnum;
import org.qiunet.utils.fakeenum.FakeEnumClass;
import org.qiunet.utils.reflect.ReflectUtil;
import org.qiunet.utils.scanner.IApplicationContext;
import org.qiunet.utils.scanner.IApplicationContextAware;
import org.qiunet.utils.scanner.ScannerType;

class FakeEnumManager {
    FakeEnumManager() {
    }

    static <T extends FakeEnum<T>> T valueOfEnum(String enumType, String name) {
        EnumData<? extends FakeEnum> enumData = FakeEnumManager0.instance.enumConstants.get(enumType);
        if (enumData == null) {
            return null;
        }
        return (T)((FakeEnum)enumData.data.get(name));
    }

    static <T extends FakeEnum<T>> List<T> values(String enumType) {
        EnumData<? extends FakeEnum> enumData = FakeEnumManager0.instance.enumConstants.get(enumType);
        if (enumData == null) {
            return null;
        }
        return enumData.values();
    }

    private static enum FakeEnumManager0 implements IApplicationContextAware
    {
        instance;

        private final Map<String, EnumData<? extends FakeEnum>> enumConstants = Maps.newHashMap();

        @Override
        public void setApplicationContext(IApplicationContext context, ArgsContainer argsContainer) throws Exception {
            Set<Class<?>> classSet = context.getTypesAnnotatedWith(FakeEnumClass.class);
            classSet.forEach(this::enumClassProcess);
        }

        public void enumClassProcess(Class<?> clazz) {
            List fieldList = Stream.of(clazz.getDeclaredFields()).sorted((o1, o2) -> ComparisonChain.start().compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName())).result()).collect(Collectors.toList());
            for (Field field : fieldList) {
                String enumName;
                if (!FakeEnum.class.isAssignableFrom(field.getType())) continue;
                if (!Modifier.isStatic(field.getModifiers())) {
                    throw new CustomException("FakeEnum [{}#{}] need be static", field.getDeclaringClass().getName(), field.getName());
                }
                EnumData data = this.enumConstants.computeIfAbsent(field.getType().getName(), key -> new EnumData());
                if (data.containsKey(enumName = field.getName())) {
                    throw new CustomException("FakeEnum name [{}] in field [{}] is repeated", enumName, field.getName());
                }
                FakeEnum fieldVal = (FakeEnum)ReflectUtil.getField(field, null);
                if (fieldVal != null && !Modifier.isFinal(field.getModifiers())) {
                    throw new CustomException("Valued field [{}] need be a final field", field.getName());
                }
                if (fieldVal == null) {
                    fieldVal = (FakeEnum)ReflectUtil.newInstance(field.getType(), new Object[0]);
                    ReflectUtil.setField(null, field, (Object)fieldVal);
                }
                ReflectUtil.setField((Object)fieldVal, "ordinal", (Object)data.id.getAndIncrement());
                ReflectUtil.setField((Object)fieldVal, "name", (Object)enumName);
                data.add(enumName, fieldVal);
            }
        }

        @Override
        public ScannerType scannerType() {
            return ScannerType.FAKE_ENUM;
        }
    }

    private static class EnumData<E extends FakeEnum<E>> {
        private final LazyLoader<List<E>> values = new LazyLoader<List>(this::toValues);
        private final Map<String, E> data = Maps.newHashMap();
        private final AtomicInteger id = new AtomicInteger();

        public boolean containsKey(String name) {
            return this.data.containsKey(name);
        }

        public List<E> values() {
            return this.values.get();
        }

        private List<E> toValues() {
            return this.data.values().stream().sorted((o1, o2) -> ComparisonChain.start().compare(o1.ordinal(), o2.ordinal()).result()).collect(DCollectors.toSafeList());
        }

        public void add(String name, E fakeEnum) {
            this.data.put(name, fakeEnum);
        }
    }
}

