/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.file;

import java.io.File;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.qiunet.utils.exceptions.CustomException;

public class DPath {
    public static String fileName(String path) {
        if (path.contains("\\")) {
            return path.substring(path.lastIndexOf("\\") + 1);
        }
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public static String dirName(String path) {
        if (path.contains("\\")) {
            return path.substring(0, path.lastIndexOf("\\"));
        }
        return path.substring(0, path.lastIndexOf("/"));
    }

    public static void listDir(String dirPath, Consumer<File> consumer, Predicate<File> filter) {
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            throw new CustomException("{} not a directory", dirPath);
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (filter != null && !filter.test(file)) continue;
            consumer.accept(file);
        }
    }
}

