/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.file;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import org.qiunet.utils.file.FileChangeObserver;
import org.qiunet.utils.file.IFileChangeCallback;
import org.qiunet.utils.timer.IScheduledTask;

class FileChangeMonitor
implements IScheduledTask {
    private final Map<String, FileChangeObserver> observerMap = Maps.newConcurrentMap();

    FileChangeMonitor() {
    }

    void addObserver(File file, IFileChangeCallback callback) {
        Preconditions.checkState((file != null && file.exists() && file.isFile() ? 1 : 0) != 0);
        FileChangeObserver fileChangeObserver = this.observerMap.computeIfAbsent(file.toString(), key -> new FileChangeObserver(file));
        fileChangeObserver.addCallback(callback);
    }

    @Override
    public void run0() {
        this.observerMap.values().forEach(FileChangeObserver::checkAndNotify);
    }
}

