/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.file;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.qiunet.utils.file.IFileChangeCallback;

class FileChangeObserver {
    private final File file;
    private long length;
    private long lastModified;
    private final List<IFileChangeCallback> changeCallbacks = Lists.newArrayListWithCapacity((int)3);

    FileChangeObserver(File file) {
        this.lastModified = file.lastModified();
        this.length = file.length();
        this.file = file;
    }

    String getName() {
        return this.getFile().toString();
    }

    File getFile() {
        return this.file;
    }

    synchronized void addCallback(IFileChangeCallback changeCallback) {
        this.changeCallbacks.add(changeCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAndNotify() {
        long lastModify = this.file.lastModified();
        long len = this.file.length();
        if (this.lastModified != lastModify || this.length != len) {
            FileChangeObserver fileChangeObserver = this;
            synchronized (fileChangeObserver) {
                this.changeCallbacks.forEach(changeCallback -> changeCallback.call(this.file));
            }
        }
        this.lastModified = lastModify;
        this.length = len;
    }

    public String toString() {
        return "FileChangeObserver{file=" + this.file + ", length=" + this.length + ", lastModified=" + this.lastModified + "}";
    }
}

