/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.file;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.file.FileChangeListener;
import org.qiunet.utils.file.IFileChangeCallback;
import org.qiunet.utils.logger.LoggerType;
import org.slf4j.Logger;

public class FileUtil {
    private static final Logger logger = LoggerType.DUODUO.getLogger();

    public static boolean move(File srcFile, String destPath) {
        File dir = new File(destPath);
        return srcFile.renameTo(new File(dir, srcFile.getName()));
    }

    public static boolean move(String srcFile, String destPath) {
        return FileUtil.move(new File(srcFile), destPath);
    }

    public static void copy(String oldPath, String newPath) {
        FileUtil.copy(new File(oldPath), newPath);
    }

    public static void copy(File oldFile, String newPath) {
        if (!oldFile.exists() || !oldFile.isFile()) {
            throw new IllegalArgumentException("file [" + oldFile.getAbsolutePath() + "] is not exist or is not a file!");
        }
        try (FileOutputStream fs = new FileOutputStream(newPath);){
            fs.write(Files.readAllBytes(oldFile.toPath()));
        }
        catch (Exception e) {
            throw new CustomException(e, "File Copy exception!", new Object[0]);
        }
    }

    public static void appendToFile(File file, String msg) {
        FileUtil.writeStringToFile(file, msg, StandardCharsets.UTF_8, true, "\n");
    }

    public static void createFileWithContent(File file, String content) {
        FileUtil.writeStringToFile(file, content, StandardCharsets.UTF_8, false, "");
    }

    public static void writeStringToFile(File file, String data, Charset charset, boolean append, String endChar) {
        if (file.isDirectory()) {
            logger.error("File '{}' exists but is a directory", (Object)file);
            return;
        }
        if (!(file.exists() || file.getParentFile().exists() || file.getParentFile().mkdirs())) {
            logger.error("Directory '{}' could not be created", (Object)file.getParent());
            return;
        }
        try (FileOutputStream output = new FileOutputStream(file, append);){
            output.write((data + endChar).getBytes(charset));
        }
        catch (Exception e) {
            logger.error("FileUtil Exception", (Throwable)e);
        }
    }

    public static List<String> tailFile(File file, int lastNum) {
        return FileUtil.tailFile(file, 0L, lastNum);
    }

    public static List<String> tailFile(File file, long startPos, int lastNum) {
        if (startPos > 0L) {
            --startPos;
        }
        ArrayList<String> result = new ArrayList<String>();
        long length = FileUtil.getFileLength(file);
        if (length <= 0L || startPos < 0L) {
            return result;
        }
        long pos = length - 1L;
        int count = 0;
        try (RandomAccessFile reader = new RandomAccessFile(file, "r");){
            while (pos-- > startPos) {
                reader.seek(pos);
                if (pos != 0L && reader.readByte() != 10) continue;
                result.add(StandardCharsets.UTF_8.decode(StandardCharsets.ISO_8859_1.encode(reader.readLine())).toString());
                if (++count < lastNum) continue;
                break;
            }
        }
        catch (IOException e) {
            logger.error("Exception", (Throwable)e);
        }
        if (!result.isEmpty()) {
            Collections.reverse(result);
        }
        return result;
    }

    public static long getFileLength(File file) {
        if (file == null || file.isDirectory() || !file.exists()) {
            throw new CustomException("File is empty or null", new Object[0]);
        }
        if (!file.canRead()) {
            return 0L;
        }
        return file.length();
    }

    private FileUtil() {
    }

    public static void deleteFile(File file) throws IOException {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            if (!file.delete()) {
                throw new IOException("Unable to delete file: " + file);
            }
            return;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File file0 : files) {
            FileUtil.deleteFile(file0);
        }
        if (!file.delete()) {
            throw new IOException("Unable to delete directory: " + file);
        }
    }

    public static String getFileContent(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (!file.exists() || !file.isFile()) {
            throw new CustomException("File {} is not file or empty!", file.getAbsolutePath());
        }
        byte[] bytes = Files.readAllBytes(file.toPath());
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static void listFile(Path path, List<File> retList, Predicate<File> predicate) {
        Preconditions.checkNotNull(retList);
        File file = path.toFile();
        if (!file.exists()) {
            return;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File file2 : files) {
            if (file2.isFile() && predicate.test(file2)) {
                retList.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            FileUtil.listFile(file2.toPath(), retList, predicate);
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        IOException exception = null;
        for (File file : files) {
            try {
                FileUtil.deleteFile(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void changeListener(Path path, IFileChangeCallback changeCallback) {
        FileUtil.changeListener(path.toFile(), changeCallback);
    }

    public static void changeListener(File file, IFileChangeCallback changeCallback) {
        FileChangeListener.listener(file, changeCallback);
    }
}

