/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.http;

import java.net.URI;
import java.net.http.HttpRequest;
import java.util.Map;
import org.qiunet.utils.http.HttpRequest;
import org.qiunet.utils.json.JsonUtil;
import org.qiunet.utils.string.StringUtil;

public class PostHttpRequest
extends HttpRequest<PostHttpRequest> {
    private HttpRequest.BodyPublisher requestBody;

    PostHttpRequest(String url) {
        super(url);
    }

    public PostHttpRequest withFormData(Map<String, String> params) {
        String formData = StringUtil.mapToString(params, "=", "&");
        this.withStringData(formData);
        return this;
    }

    public PostHttpRequest withJsonData(Map<String, Object> params) {
        String json = JsonUtil.toJsonString(params);
        return this.withStringData(json);
    }

    public PostHttpRequest withStringData(String string) {
        this.requestBody = HttpRequest.BodyPublishers.ofString(string);
        return this;
    }

    public PostHttpRequest withBytes(byte[] bytes) {
        this.requestBody = HttpRequest.BodyPublishers.ofByteArray(bytes);
        return this;
    }

    public PostHttpRequest customBody(HttpRequest.BodyPublisher requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    @Override
    protected java.net.http.HttpRequest buildRequest() {
        HttpRequest.Builder builder = java.net.http.HttpRequest.newBuilder(URI.create(this.url));
        this.headerBuilder.forEach(builder::setHeader);
        if (this.requestBody != null) {
            builder.POST(this.requestBody);
        }
        return builder.build();
    }
}

