/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.util.List;

public final class JsonUtil {
    public static final ParserConfig DEFAULT_PARSER_CONFIG = new ParserConfig(true);
    public static final SerializeConfig DEFAULT_SERIALIZE_CONFIG = new SerializeConfig(true);

    private JsonUtil() {
    }

    public static String toJsonString(Object o, SerializeConfig config, SerializerFeature ... features) {
        return JSON.toJSONString((Object)o, (SerializeConfig)config, (SerializerFeature[])features);
    }

    public static String toJsonString(Object o, SerializerFeature ... features) {
        return JsonUtil.toJsonString(o, DEFAULT_SERIALIZE_CONFIG, features);
    }

    public static String toJsonString(Object o) {
        return JsonUtil.toJsonString(o, DEFAULT_SERIALIZE_CONFIG, SerializerFeature.DisableCircularReferenceDetect);
    }

    public static <T> T getGeneralObj(String jsonText, Class<T> clz, Feature ... features) {
        return JsonUtil.getGeneralObj(jsonText, clz, DEFAULT_PARSER_CONFIG, features);
    }

    public static <T> T getGeneralObj(String jsonText, Class<T> clz, ParserConfig parserConfig, Feature ... features) {
        return (T)JSON.parseObject((String)jsonText, clz, (ParserConfig)parserConfig, (Feature[])features);
    }

    public static <T> T getGeneralObj(String jsonText, TypeReference<T> type, Feature ... features) {
        return JsonUtil.getGeneralObj(jsonText, type.getType(), features);
    }

    public static <T> T getGeneralObj(String jsonText, Type type, Feature ... features) {
        return JsonUtil.getGeneralObj(jsonText, type, DEFAULT_PARSER_CONFIG, features);
    }

    public static <T> T getGeneralObj(String jsonText, TypeReference<T> type, ParserConfig parserConfig, Feature ... features) {
        return JsonUtil.getGeneralObj(jsonText, type.getType(), parserConfig, features);
    }

    public static <T> T getGeneralObj(String jsonText, Type type, ParserConfig parserConfig, Feature ... features) {
        return (T)JSON.parseObject((String)jsonText, (Type)type, (ParserConfig)parserConfig, (Feature[])features);
    }

    public static <T> List<T> getGeneralList(String json, Class<T> c) {
        return JsonUtil.getGeneralList(json, c, DEFAULT_PARSER_CONFIG);
    }

    public static <T> List<T> getGeneralList(String json, Class<T> c, ParserConfig config) {
        return JSON.parseArray((String)json, c, (ParserConfig)config);
    }

    public static JSONObject toJsonObject(Object obj) {
        return JsonUtil.toJsonObject(obj, DEFAULT_SERIALIZE_CONFIG);
    }

    public static JSONObject toJsonObject(Object obj, SerializeConfig config) {
        return (JSONObject)JSON.toJSON((Object)obj, (SerializeConfig)config);
    }
}

