/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.listener.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.qiunet.utils.args.ArgsContainer;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.listener.event.EventListener;
import org.qiunet.utils.listener.event.IEventData;
import org.qiunet.utils.logger.LoggerType;
import org.qiunet.utils.scanner.IApplicationContext;
import org.qiunet.utils.scanner.IApplicationContextAware;
import org.qiunet.utils.scanner.ScannerType;

enum EventManager0 implements IApplicationContextAware
{
    instance;

    private final Map<Class<? extends IEventData>, List<EventSubscriber>> listeners = new HashMap<Class<? extends IEventData>, List<EventSubscriber>>();
    private final AtomicBoolean inited = new AtomicBoolean();
    private IApplicationContext context;

    static EventManager0 getInstance() {
        return instance;
    }

    @Override
    public void setApplicationContext(IApplicationContext context, ArgsContainer argsContainer) throws Exception {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        this.context = context;
        Set<Method> typesAnnotated = context.getMethodsAnnotatedWith(EventListener.class);
        for (Method method : typesAnnotated) {
            Class<? extends IEventData> eventDataClass = this.eventDataClass(method);
            List subscriberList = this.listeners.computeIfAbsent(eventDataClass, key -> Lists.newArrayList());
            subscriberList.add(this.wrapper(method));
        }
        this.listeners.values().forEach(list -> list.sort((o1, o2) -> ComparisonChain.start().compare(o2.weight, o1.weight).result()));
        LoggerType.DUODUO.debug("EventManager find {} event!", this.listeners.size());
    }

    @Override
    public ScannerType scannerType() {
        return ScannerType.EVENT;
    }

    @Override
    public int order() {
        return 0x7FFFFFFD;
    }

    private Class<? extends IEventData> eventDataClass(Method method) {
        Preconditions.checkArgument((method.getParameterCount() == 1 ? 1 : 0) != 0, (String)"EventListener Method parameter count %s error!", (int)method.getParameterCount());
        Preconditions.checkArgument((boolean)IEventData.class.isAssignableFrom(method.getParameterTypes()[0]), (Object)"EventListener Method parameter must be IEventData");
        return method.getParameterTypes()[0];
    }

    private EventSubscriber wrapper(Method method) {
        EventListener annotation = method.getAnnotation(EventListener.class);
        Object implInstance = null;
        if (!Modifier.isStatic(method.getModifiers())) {
            implInstance = this.context.getInstanceOfClass(method.getDeclaringClass(), new Object[0]);
        }
        return new EventSubscriber(implInstance, method, annotation.value().ordinal(), annotation.limitCount());
    }

    void post(IEventData eventData) {
        if (!this.inited.get()) {
            throw new CustomException("Event not init", new Object[0]);
        }
        List<EventSubscriber> wrappers = this.listeners.get(eventData.getClass());
        if (wrappers == null) {
            return;
        }
        wrappers.forEach(w -> w.handleEvent(eventData));
    }

    private static class EventSubscriber {
        private final int weight;
        private final Method method;
        private final Object caller;
        private final int limitCount;
        private int currCount;

        private EventSubscriber(Object caller, Method method, int weight, int limitCount) {
            this.caller = caller;
            this.weight = weight;
            this.method = method;
            this.limitCount = limitCount;
            method.setAccessible(true);
        }

        void handleEvent(IEventData data) {
            if (this.limitCount != 0 && (this.currCount >= this.limitCount || this.currCount++ >= this.limitCount)) {
                return;
            }
            try {
                this.method.invoke(this.caller, data);
            }
            catch (IllegalAccessException e) {
                throw new CustomException(e, "Fire Event Handler [{}.{}] Error!", this.caller.getClass().getName(), this.method.getName());
            }
            catch (InvocationTargetException e) {
                if (!(e.getTargetException() instanceof CustomException)) {
                    throw new CustomException(e.getTargetException(), "Fire Event Handler [{}.{}] Error!", this.caller.getClass().getName(), this.method.getName());
                }
                throw (CustomException)e.getTargetException();
            }
        }
    }
}

