/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.listener.hook;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.listener.event.EventHandlerWeightType;
import org.qiunet.utils.listener.event.EventListener;
import org.qiunet.utils.listener.event.data.ServerShutdownEventData;
import org.qiunet.utils.listener.hook.IShutdownCloseHook;
import org.qiunet.utils.logger.LoggerType;
import org.slf4j.Logger;

public class ShutdownHookUtil {
    private final LinkedList<IShutdownCloseHook> closes = new LinkedList();
    private final Logger logger = LoggerType.DUODUO.getLogger();
    private final AtomicBoolean executing = new AtomicBoolean();
    private static ShutdownHookUtil instance;

    private ShutdownHookUtil() {
        if (instance != null) {
            throw new CustomException("Instance Duplication!", new Object[0]);
        }
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShutdownHookUtil getInstance() {
        if (instance != null) return instance;
        Class<ShutdownHookUtil> clazz = ShutdownHookUtil.class;
        synchronized (ShutdownHookUtil.class) {
            if (instance != null) return instance;
            new ShutdownHookUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addFirst(IShutdownCloseHook closeHook) {
        this.closes.addFirst(closeHook);
    }

    public void addLast(IShutdownCloseHook closeHook) {
        this.closes.addLast(closeHook);
    }

    public void addShutdownHook(IShutdownCloseHook closeHook) {
        this.addLast(closeHook);
    }

    private void shutdownNow() {
        if (this.executing.compareAndSet(false, true)) {
            this.run();
        }
    }

    @EventListener(value=EventHandlerWeightType.LESS)
    public void onShutdown(ServerShutdownEventData data) {
        this.shutdownNow();
    }

    private void run() {
        this.logger.error("----------------Shutdown now-----------------------");
        for (IShutdownCloseHook close : this.closes) {
            try {
                close.close();
                this.logger.info("Closed [" + close.getClass().getName() + "]");
            }
            catch (Exception e) {
                this.logger.error("Closing [" + close.getClass().getName() + "], But Exception.", (Throwable)e);
            }
        }
        this.logger.error("----------------Shutdown over-----------------------");
    }
}

