/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.logger;

import java.util.function.Supplier;
import org.slf4j.Logger;

public interface ILoggerType {
    public Logger getLogger();

    default public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    default public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    default public boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    default public void debug(Supplier<String> msg) {
        if (this.isDebugEnabled()) {
            this.debug(msg.get());
        }
    }

    default public void info(Supplier<String> msg) {
        if (this.isInfoEnabled()) {
            this.info(msg.get());
        }
    }

    default public void error(Supplier<String> msg) {
        if (this.isErrorEnabled()) {
            this.error(msg.get());
        }
    }

    default public void debug(String msg) {
        this.getLogger().debug(msg);
    }

    default public void debug(String format, Object ... arguments) {
        this.getLogger().debug(format, arguments);
    }

    default public void info(String msg) {
        this.getLogger().info(msg);
    }

    default public void info(String format, Object ... arguments) {
        this.getLogger().info(format, arguments);
    }

    default public void warn(String msg) {
        this.getLogger().warn(msg);
    }

    default public void warn(String format, Object ... arguments) {
        this.getLogger().warn(format, arguments);
    }

    default public void error(String msg) {
        this.getLogger().error(msg);
    }

    default public void error(String format, Object ... arguments) {
        this.getLogger().error(format, arguments);
    }

    default public void error(String msg, Throwable e) {
        this.getLogger().error(msg, e);
    }
}

