/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.math;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.qiunet.utils.math.MathUtil;
import org.qiunet.utils.math.PollChooserFactory;

public class DefaultPollChooserFactory
implements PollChooserFactory {
    DefaultPollChooserFactory() {
    }

    @Override
    public <Element> PollChooserFactory.PollChooser<Element> newChooser(List<Element> executors) {
        ArrayList list = null;
        list = executors instanceof ArrayList ? (ArrayList)executors : Lists.newArrayList(executors);
        if (MathUtil.isPowerOfTwo(executors.size())) {
            return new PowerOfTwoPollChooser(list);
        }
        return new GenericPollChooser(list);
    }

    private static final class PowerOfTwoPollChooser<Element>
    implements PollChooserFactory.PollChooser<Element> {
        private final AtomicInteger idx = new AtomicInteger();
        private final ArrayList<Element> elements;

        PowerOfTwoPollChooser(ArrayList<Element> elements) {
            this.elements = elements;
        }

        @Override
        public Element next() {
            return this.elements.get(this.idx.getAndIncrement() & this.elements.size() - 1);
        }
    }

    private static final class GenericPollChooser<Element>
    implements PollChooserFactory.PollChooser<Element> {
        private final AtomicInteger idx = new AtomicInteger();
        private final ArrayList<Element> elements;

        GenericPollChooser(ArrayList<Element> elements) {
            this.elements = elements;
        }

        @Override
        public Element next() {
            return this.elements.get(Math.abs(this.idx.getAndIncrement() % this.elements.size()));
        }
    }
}

