/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.math;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.math.IWeightObj;

public class MathUtil {
    private static final long BASE_RATE = 10000L;

    private MathUtil() {
    }

    public static int random(int start, int end, RandomType randomType) {
        if (end - start < 0) {
            int smaller = end;
            end = start;
            start = smaller;
        } else if (end - start == 0) {
            return start;
        }
        if (randomType == RandomType.B) {
            ++end;
        }
        int rt = start + MathUtil.random(end - start);
        return rt;
    }

    public static int random(int start, int end) {
        return MathUtil.random(start, end, RandomType.K);
    }

    public static double random(double start, double end) {
        return ThreadLocalRandom.current().nextDouble(start, end);
    }

    public static int random(int i) {
        return ThreadLocalRandom.current().nextInt(i);
    }

    public static float random(float i) {
        return i * ThreadLocalRandom.current().nextFloat();
    }

    public static boolean isPowerOfTwo(int val) {
        return (val & -val) == val;
    }

    public static String getHexVal(long val) {
        return String.format("%x", val).toUpperCase();
    }

    public static String getHexVal(long val, int count) {
        return String.format("%0" + count + "x", val).toUpperCase();
    }

    public static String getBinaryVal(int val) {
        return Integer.toBinaryString(val);
    }

    public static <T extends IWeightObj> T randByWeight(List<T> list) {
        int totalRandNum = list.stream().mapToInt(IWeightObj::weight).sum();
        return MathUtil.randByWeight(list, totalRandNum);
    }

    public static <T extends IWeightObj> T randByWeight(List<T> list, int totalRandNum) {
        int rand = MathUtil.random(totalRandNum);
        int start = 0;
        for (IWeightObj obj : list) {
            if (rand >= start && rand < start + obj.weight()) {
                return (T)obj;
            }
            start += obj.weight();
        }
        return null;
    }

    public static long getByRate(long val, long rate) {
        return val * rate / 10000L;
    }

    public static boolean isHit(int rate) {
        return MathUtil.random(10000) <= rate;
    }

    public static int toInt(long val) {
        int i = (int)val;
        if ((long)i != val) {
            throw new CustomException("value {} out of int range!", val);
        }
        return i;
    }

    public static enum RandomType {
        K,
        B;

    }
}

