/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.net;

import com.google.common.net.InetAddresses;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.qiunet.utils.common.CommonUtil;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.logger.LoggerType;
import org.qiunet.utils.string.StringUtil;
import org.qiunet.utils.thread.ThreadPoolManager;

public class NetUtil {
    private static final int IPV6_MAX_HEX_DIGITS_PER_GROUP = 4;
    private static final int IPV6_MAX_HEX_GROUPS = 8;
    private static final int MAX_UNSIGNED_SHORT = 65535;
    public static final int PORT_RANGE_MAX = 65535;
    public static final int PORT_RANGE_MIN = 1024;
    private static final int MAX_BYTE = 128;
    private static final int BASE_16 = 16;

    public static boolean isLocalIp(String ip) {
        return CommonUtil.existInList(ip, "localhost", "0:0:0:0:0:0:0:1", "127.0.0.1");
    }

    public static boolean isInnerIp(String ip) {
        InetAddress inetAddress = InetAddresses.forString((String)ip);
        return NetUtil.isInnerIp(inetAddress);
    }

    public static boolean isInnerIp(InetAddress inetAddress) {
        return inetAddress.isSiteLocalAddress() || inetAddress.isLoopbackAddress();
    }

    public static String getInnerIp() {
        return NetUtil.localIpv4s().stream().filter(str -> !NetUtil.isLocalIp(str)).findFirst().get();
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static String getPublicIp6() {
        LinkedHashSet<String> strings = NetUtil.localIpv6s();
        for (String string : strings) {
            if (string.startsWith("0:0:0:0:0:0:0:1") || string.startsWith("fe80") || string.startsWith("fE80") || string.startsWith("Fc00") || string.startsWith("FC00") || string.startsWith("Fec0") || string.startsWith("FEC0")) continue;
            String ip = StringUtil.split(string, "%")[0];
            LoggerType.DUODUO_FLASH_HANDLER.error("Use ipv6 address: {}", ip);
            return ip;
        }
        throw new CustomException("Not support ipv6!", new Object[0]);
    }

    public static String getPublicIp4() {
        LinkedHashSet<InetAddress> inetAddresses = NetUtil.localAddressList(address -> !NetUtil.isInnerIp(address) && address instanceof Inet4Address);
        Optional first = inetAddresses.stream().findFirst();
        String ip = first.map(InetAddress::getHostAddress).orElse(null);
        if (!StringUtil.isEmpty(ip)) {
            return ip;
        }
        String[] IPV4_SERVICES = new String[]{"http://checkip.amazonaws.com", "https://ipv4.icanhazip.com", "https://icanhazip.com", "https://ipinfo.io/ip"};
        List callables = Stream.of(IPV4_SERVICES).map(str -> () -> {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(new URL((String)str).openStream()));){
                String result = in.readLine();
                LoggerType.DUODUO.error("Get public ip {} from {}!", result, str);
                if (!NetUtil.isValidIp4(result)) {
                    throw new CustomException("ip invalid!", new Object[0]);
                }
                String string = result;
                return string;
            }
        }).collect(Collectors.toList());
        try {
            String publicIp = (String)ThreadPoolManager.NORMAL.invokeAny(callables);
            LoggerType.DUODUO.error("current public ip: {}", publicIp);
            return publicIp;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CustomException("No public ip get!", new Object[0]);
        }
    }

    public static boolean isValidIp4(String host) {
        String[] strings = StringUtil.split(host, ".");
        if (strings.length != 4) {
            return false;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (!StringUtil.isNum(strings[i])) {
                return false;
            }
            int i1 = Integer.parseInt(strings[i]);
            if (i1 >= 0 && i1 <= 255) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidIp6(String inet6Address) {
        String[] parts = inet6Address.split("/", -1);
        if (parts.length > 2) {
            return false;
        }
        if (parts.length == 2) {
            if (!parts[1].matches("\\d{1,3}")) {
                return false;
            }
            int bits = Integer.parseInt(parts[1]);
            if (bits < 0 || bits > 128) {
                return false;
            }
        }
        if ((parts = parts[0].split("%", -1)).length > 2) {
            return false;
        }
        if (parts.length == 2 && !parts[1].matches("[^\\s/%]+")) {
            return false;
        }
        inet6Address = parts[0];
        boolean containsCompressedZeroes = inet6Address.contains("::");
        if (containsCompressedZeroes && inet6Address.indexOf("::") != inet6Address.lastIndexOf("::")) {
            return false;
        }
        if (inet6Address.startsWith(":") && !inet6Address.startsWith("::") || inet6Address.endsWith(":") && !inet6Address.endsWith("::")) {
            return false;
        }
        String[] octets = inet6Address.split(":");
        if (containsCompressedZeroes) {
            ArrayList<String> octetList = new ArrayList<String>(Arrays.asList(octets));
            if (inet6Address.endsWith("::")) {
                octetList.add("");
            } else if (inet6Address.startsWith("::") && !octetList.isEmpty()) {
                octetList.remove(0);
            }
            octets = octetList.toArray(new String[octetList.size()]);
        }
        if (octets.length > 8) {
            return false;
        }
        int validOctets = 0;
        int emptyOctets = 0;
        for (int index = 0; index < octets.length; ++index) {
            String octet = octets[index];
            if (octet.isEmpty()) {
                if (++emptyOctets > 1) {
                    return false;
                }
            } else {
                emptyOctets = 0;
                if (index == octets.length - 1 && octet.contains(".")) {
                    if (!NetUtil.isValidIp4(octet)) {
                        return false;
                    }
                    validOctets += 2;
                    continue;
                }
                if (octet.length() > 4) {
                    return false;
                }
                int octetInt = 0;
                try {
                    octetInt = Integer.parseInt(octet, 16);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (octetInt < 0 || octetInt > 65535) {
                    return false;
                }
            }
            ++validOctets;
        }
        return validOctets <= 8 && (validOctets >= 8 || containsCompressedZeroes);
    }

    public static void socketSendData(String host, int port, byte[] data) throws IOException {
        try (SocketChannel channel = SocketChannel.open(InetSocketAddress.createUnresolved(host, port));){
            channel.write(ByteBuffer.wrap(data));
        }
    }

    public static void udpSendData(String host, int port, byte[] data) throws IOException {
        try (DatagramChannel channel = DatagramChannel.open();){
            channel.send(ByteBuffer.wrap(data), new InetSocketAddress(host, port));
        }
    }

    public static String getLocalHostName() {
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LoggerType.DUODUO.error("", e);
        }
        return address != null ? address.getHostName() : null;
    }

    public static String[] getAllInnerIp() {
        LinkedHashSet<InetAddress> inetAddresses = NetUtil.localAddressList(i -> true);
        return NetUtil.toIpList(inetAddresses).toArray(new String[0]);
    }

    public static LinkedHashSet<String> localIpv4s() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(t -> t instanceof Inet4Address);
        return NetUtil.toIpList(localAddressList);
    }

    public static LinkedHashSet<String> localIpv6s() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(t -> t instanceof Inet6Address);
        return NetUtil.toIpList(localAddressList);
    }

    public static LinkedHashSet<String> toIpList(Set<InetAddress> addressList) {
        LinkedHashSet<String> ipSet = new LinkedHashSet<String>();
        for (InetAddress address : addressList) {
            ipSet.add(address.getHostAddress());
        }
        return ipSet;
    }

    public static LinkedHashSet<InetAddress> localAddressList(Predicate<InetAddress> addressFilter) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        if (networkInterfaces == null) {
            throw new CustomException("Get network interface error!", new Object[0]);
        }
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || null != addressFilter && !addressFilter.test(inetAddress)) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }
}

