/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.pool;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.qiunet.utils.system.OSUtil;

public abstract class ObjectPool<T> {
    private static final ThreadLocal<Map<DStack<?>, LinkedBlockingDeque<Node<?>>>> DELAYED_QUEUE = ThreadLocal.withInitial(HashMap::new);
    private final ThreadLocal<DStack<T>> stackThreadLocal = ThreadLocal.withInitial(() -> new DStack(Thread.currentThread(), maxCapacity, queueCapacityForPerThread));

    public ObjectPool() {
        this(512, OSUtil.availableProcessors() * 2);
    }

    public ObjectPool(int maxCapacity, int queueCapacityForPerThread) {
    }

    protected abstract T newObject(Handle<T> var1);

    public int threadScopeSize() {
        DStack<T> tdStack = this.stackThreadLocal.get();
        int sum = tdStack.asyncRecycleMap.values().stream().mapToInt(LinkedBlockingDeque::size).sum();
        return tdStack.stack.size + sum;
    }

    public int threadScopeStackSize() {
        DStack<T> tdStack = this.stackThreadLocal.get();
        return tdStack.stack.size;
    }

    public int asyncThreadRecycleSize() {
        DStack<T> tdStack = this.stackThreadLocal.get();
        return tdStack.asyncRecycleMap.values().stream().mapToInt(LinkedBlockingDeque::size).sum();
    }

    public T get() {
        DStack<T> tdStack = this.stackThreadLocal.get();
        Node<T> node = tdStack.pop();
        if (node == null) {
            node = tdStack.newHandler();
            node.value = this.newObject(node);
            Preconditions.checkNotNull(node.value);
        }
        return node.value;
    }

    private static final class DStack<T> {
        final Map<Thread, LinkedBlockingDeque<Node<?>>> asyncRecycleMap = Maps.newConcurrentMap();
        final Set<Thread> needRecycleThreads = Sets.newConcurrentHashSet();
        final AtomicBoolean needRecycleThread = new AtomicBoolean();
        final WeakReference<Thread> threadRef;
        final int queueCapacityForPerThread;
        final DLinkedList<T> stack;
        final int maxCapacity;

        DStack(Thread thread, int maxCapacity, int queueCapacityForPerThread) {
            this.queueCapacityForPerThread = queueCapacityForPerThread;
            this.threadRef = new WeakReference<Thread>(thread);
            this.stack = new DLinkedList(maxCapacity);
            this.maxCapacity = maxCapacity;
        }

        Node<T> newHandler() {
            return new Node(this);
        }

        Node<T> pop() {
            if (this.needRecycleThread.get()) {
                this.scannerSpecifyThread();
            }
            if (this.stack.isEmpty() && !this.scannerAllThread()) {
                return null;
            }
            if (this.stack.isEmpty()) {
                return null;
            }
            Node<T> node = this.stack.poll();
            if (node != null) {
                node.recycled = false;
            }
            return node;
        }

        private void scannerSpecifyThread() {
            Iterator<Thread> it = this.needRecycleThreads.iterator();
            while (it.hasNext()) {
                LinkedBlockingDeque<Node<?>> deque = this.asyncRecycleMap.get(it.next());
                if (deque != null) {
                    this.recycleDequeNode(deque);
                }
                it.remove();
            }
            this.needRecycleThread.set(false);
        }

        private boolean scannerAllThread() {
            for (LinkedBlockingDeque<Node<?>> deque : this.asyncRecycleMap.values()) {
                this.recycleDequeNode(deque);
            }
            return !this.stack.isEmpty();
        }

        private void recycleDequeNode(LinkedBlockingDeque<Node<?>> deque) {
            deque.drainTo(this.stack);
        }

        void push(Node<T> obj) {
            if (this.threadRef.get() == Thread.currentThread()) {
                this.stack.add(obj);
            } else {
                this.asyncPush(obj);
            }
        }

        private void asyncPush(Node<T> obj) {
            Map<DStack<?>, LinkedBlockingDeque<Node<?>>> map = DELAYED_QUEUE.get();
            LinkedBlockingDeque<Node<Object>> deque = map.get(this);
            Thread currentThread = Thread.currentThread();
            if (deque == null) {
                deque = new LinkedBlockingDeque();
                this.asyncRecycleMap.put(currentThread, deque);
                map.put(this, deque);
            }
            if (deque.size() >= this.queueCapacityForPerThread) {
                if (this.stack.lastCapacity() < this.queueCapacityForPerThread) {
                    return;
                }
                this.needRecycleThreads.add(currentThread);
                this.needRecycleThread.set(true);
            }
            deque.addLast(obj);
        }
    }

    private static final class DLinkedList<T>
    extends AbstractCollection<Node<T>> {
        private final int maxCapacity;
        private Node<T> head;
        private Node<T> tail;
        private int size;

        public DLinkedList(int maxCapacity) {
            Preconditions.checkState((maxCapacity >= 10 ? 1 : 0) != 0);
            this.maxCapacity = maxCapacity;
        }

        @Override
        public Iterator<Node<T>> iterator() {
            return new DIterator<T>(this.head);
        }

        @Override
        public int size() {
            return this.size;
        }

        public int lastCapacity() {
            return this.maxCapacity - this.size;
        }

        @Override
        public boolean add(Node<T> t) {
            if (this.lastCapacity() <= 0) {
                return false;
            }
            if (this.isEmpty()) {
                this.tail = t;
                this.head = this.tail;
                ++this.size;
                return true;
            }
            this.tail.next = t;
            t.pre = this.tail;
            this.tail = t;
            ++this.size;
            return true;
        }

        public Node<T> poll() {
            if (this.isEmpty()) {
                return null;
            }
            Node<T> temp = this.head;
            if (this.size == 1) {
                this.tail = null;
                this.head = null;
            } else {
                this.head = this.head.next;
                this.head.pre = null;
            }
            temp.pre = null;
            temp.next = null;
            --this.size;
            return temp;
        }
    }

    private static final class Node<T>
    implements Handle<T> {
        private boolean recycled;
        DStack<T> stack;
        T value;
        Node<T> pre;
        Node<T> next;

        public Node(DStack<T> stack) {
            this.stack = stack;
        }

        @Override
        public void recycle() {
            if (this.recycled) {
                throw new IllegalStateException("Already recycled!");
            }
            this.recycled = true;
            this.stack.push(this);
        }
    }

    public static interface Handle<T> {
        public void recycle();
    }

    private static final class DIterator<T>
    implements Iterator<Node<T>> {
        private Node<T> node;

        public DIterator(Node<T> node) {
            this.node = node;
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public Node<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Node<T> temp = this.node;
            this.node = this.node.next;
            return temp;
        }
    }
}

