/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.pool;

import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.qiunet.utils.exceptions.CustomException;

public class ThreadScopeObjectPool<T> {
    private final ThreadLocal<NStack<T>> threadLocal = ThreadLocal.withInitial(NStack::new);
    private final int maxElement;
    private final Consumer<T> onDrop;
    private final Supplier<T> getter;

    public ThreadScopeObjectPool(Supplier<T> getter) {
        this(null, getter, 10);
    }

    public ThreadScopeObjectPool(Consumer<T> onDrop, Supplier<T> getter, int maxElement) {
        this.maxElement = maxElement;
        this.onDrop = onDrop;
        this.getter = getter;
    }

    public T get() {
        NStack<T> stack = this.threadLocal.get();
        if (stack.size() == 0) {
            return this.getter.get();
        }
        return stack.pop();
    }

    public int threadScopeSize() {
        return this.threadLocal.get().size();
    }

    public void recycle(T obj) {
        NStack<T> stack = this.threadLocal.get();
        if (!stack.isThreadValid()) {
            if (this.onDrop != null) {
                this.onDrop.accept(obj);
            }
            throw new CustomException("Not in get thread!", new Object[0]);
        }
        if (stack.size() >= this.maxElement) {
            if (this.onDrop != null) {
                this.onDrop.accept(obj);
            }
            return;
        }
        stack.push(obj);
    }

    public void clear() {
        if (this.onDrop != null) {
            this.threadLocal.get().stack.forEach(this.onDrop);
        }
        this.threadLocal.get().stack.clear();
    }

    public static class NStack<T> {
        private final Stack<T> stack = new Stack();
        private final Thread t = Thread.currentThread();

        public T pop() {
            return this.stack.pop();
        }

        public void push(T t) {
            this.stack.push(t);
        }

        public int size() {
            return this.stack.size();
        }

        public boolean isThreadValid() {
            return Thread.currentThread() == this.t;
        }
    }
}

